/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.utils;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ow2.proactive.utils.OperatingSystem;
import org.ow2.proactive.utils.OperatingSystemFamily;

public class Environment {
    public static final Logger logger = Logger.getLogger(Environment.class);
    private static POSIX posix;

    static POSIX getPOSIXinstance() {
        if (posix == null) {
            posix = new POSIX();
        }
        return posix;
    }

    public static int unsetenv(String name) {
        Map<String, String> map = Environment.getenv();
        map.remove(name);
        Map<String, String> env2 = Environment.getwinenv();
        env2.remove(name);
        return Environment.getPOSIXinstance().unsetenv(name);
    }

    public static int setenv(String name, String value, boolean overwrite) {
        if (name.lastIndexOf("=") != -1) {
            throw new IllegalArgumentException("Environment variable cannot contain '='");
        }
        Map<String, String> map = Environment.getenv();
        boolean contains = map.containsKey(name);
        if (!contains || overwrite) {
            map.put(name, value);
            Map<String, String> env2 = Environment.getwinenv();
            env2.put(name, value);
        }
        return Environment.getPOSIXinstance().setenv(name, value, overwrite ? 1 : 0);
    }

    public static Map<String, String> getwinenv() {
        try {
            Class<?> sc = Class.forName("java.lang.ProcessEnvironment");
            Field caseinsensitive = sc.getDeclaredField("theCaseInsensitiveEnvironment");
            caseinsensitive.setAccessible(true);
            return (Map)caseinsensitive.get(null);
        }
        catch (Exception e) {
            logger.debug((Object)("Error when reading the JVM System Environment Cache : " + e.getMessage()));
            return new HashMap<String, String>();
        }
    }

    public static Map<String, String> getenv() {
        try {
            Map<String, String> theUnmodifiableEnvironment = System.getenv();
            Class<?> cu = theUnmodifiableEnvironment.getClass();
            Field m = cu.getDeclaredField("m");
            m.setAccessible(true);
            return (Map)m.get(theUnmodifiableEnvironment);
        }
        catch (Exception ex2) {
            logger.debug((Object)("Error when reading the JVM System Environment Cache : " + ex2.getMessage()));
            return new HashMap<String, String>();
        }
    }

    public static void main(String[] args) throws InterruptedException {
        Environment.setenv("TEST", "foo", true);
        String val = Environment.getenv().get("TEST");
        System.out.println(val);
        Thread.sleep(10000L);
    }

    public static class POSIX {
        Object libc = null;

        public POSIX() {
            String osName = System.getProperty("os.name");
            OperatingSystem operatingSystem = OperatingSystem.resolveOrError(osName);
            OperatingSystemFamily family = operatingSystem.getFamily();
            String[] linuxLibcNames = new String[]{"c", "libc.so.6", "libc.so.5", "libc.so.7"};
            this.libc = null;
            block2 : switch (family) {
                case LINUX: 
                case UNIX: 
                case MAC: {
                    for (String libName : linuxLibcNames) {
                        try {
                            this.libc = Native.loadLibrary((String)libName, LinuxLibC.class);
                            break block2;
                        }
                        catch (Throwable e) {
                            logger.debug((Object)("[Warning] could not load library '" + libName + "', skipping..."), e);
                        }
                    }
                    break;
                }
                case WINDOWS: {
                    try {
                        this.libc = Native.loadLibrary((String)"msvcrt", WinLibC.class);
                    }
                    catch (Throwable e) {
                        logger.debug((Object)"[Warning] could not load library 'msvcrt', skipping...", e);
                    }
                    break;
                }
            }
            if (this.libc == null) {
                logger.warn((Object)"Couldn't load the C library native env modification will be disabled.");
            }
        }

        public int setenv(String name, String value, int overwrite) {
            if (this.libc != null) {
                if (this.libc instanceof LinuxLibC) {
                    return ((LinuxLibC)this.libc).setenv(name, value, overwrite);
                }
                return ((WinLibC)this.libc)._putenv(name + "=" + value);
            }
            return 0;
        }

        public int unsetenv(String name) {
            if (this.libc != null) {
                if (this.libc instanceof LinuxLibC) {
                    return ((LinuxLibC)this.libc).unsetenv(name);
                }
                return ((WinLibC)this.libc)._putenv(name + "=");
            }
            return 0;
        }
    }

    public static interface LinuxLibC
    extends Library {
        public int setenv(String var1, String var2, int var3);

        public int unsetenv(String var1);
    }

    public static interface WinLibC
    extends Library {
        public int _putenv(String var1);
    }
}

