/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;

public final class StackTraceUtil {
    static String nl = System.getProperty("line.separator");

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static boolean equalsStackTraces(Throwable a, Throwable b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        if (!a.getClass().equals(b.getClass())) {
            return false;
        }
        if (a.getMessage() == null && b.getMessage() != null) {
            return false;
        }
        if (b.getMessage() == null && a.getMessage() != null) {
            return false;
        }
        if (a.getMessage() != null && b.getMessage() != null && !a.getMessage().equals(b.getMessage())) {
            return false;
        }
        return StackTraceUtil.equalsStackTraces(a.getCause(), b.getCause());
    }

    public static String getAllStackTraces() {
        Map<Thread, StackTraceElement[]> allThreads = Thread.getAllStackTraces();
        TreeSet<Thread> sortedThreads = new TreeSet<Thread>(new Comparator<Thread>(){

            @Override
            public int compare(Thread o1, Thread o2) {
                return (int)(o2.getId() - o1.getId());
            }
        });
        sortedThreads.addAll(allThreads.keySet());
        StringBuffer stringBuffer = new StringBuffer();
        for (Thread thread : sortedThreads) {
            StackTraceElement[] trace = allThreads.get(thread);
            StringBuffer threadInfo = new StringBuffer();
            threadInfo.append("\"" + thread.getName() + "\"");
            threadInfo.append(" #" + thread.getId());
            if (thread.getThreadGroup() != null) {
                threadInfo.append(" group=" + thread.getThreadGroup().getName());
            }
            threadInfo.append(thread.isDaemon() ? " daemon" : "");
            threadInfo.append(" prio=" + thread.getPriority());
            threadInfo.append(" " + (Object)((Object)thread.getState()));
            stringBuffer.append(threadInfo + nl);
            for (int i = 0; i < trace.length; ++i) {
                stringBuffer.append(" " + trace[i] + nl);
            }
            stringBuffer.append(nl);
        }
        return stringBuffer.toString();
    }

    @SafeVarargs
    public static <T> T[] concatAll(T[] first, T[] ... rest) {
        if (first == null) {
            throw new IllegalArgumentException("Unexpected array : " + first);
        }
        int totalLength = first.length;
        if (rest != null) {
            for (T[] array : rest) {
                if (array == null) continue;
                totalLength += array.length;
            }
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        if (rest != null) {
            for (T[] array : rest) {
                if (array == null) continue;
                System.arraycopy(array, 0, result, offset, array.length);
                offset += array.length;
            }
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(Arrays.asList(StackTraceUtil.concatAll(new Integer[]{1, 2, 3}, new Integer[][]{{4, 5, 6}})));
        System.out.println(Arrays.asList(StackTraceUtil.concatAll(new Integer[]{1, 2, 3}, null, {4, 5, 6})));
        System.out.println(Arrays.asList(StackTraceUtil.concatAll(new Integer[]{1, 2, 3}, null, {4, 5, 6}, null)));
        System.out.println(Arrays.asList(StackTraceUtil.concatAll(new Integer[]{1, 2, 3}, new Integer[][]{null})));
    }
}

