/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.IOException;
import java.util.ArrayList;
import jdbm.Serializer;
import jdbm.SerializerInput;
import jdbm.SerializerOutput;
import jdbm.helper.Serialization;
import jdbm.htree.HTree;
import jdbm.htree.HashNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HashBucket<K, V>
extends HashNode<K, V> {
    static final long serialVersionUID = 1L;
    public static final int OVERFLOW_SIZE = 8;
    private int _depth;
    private ArrayList<K> _keys;
    private ArrayList<V> _values;

    public HashBucket(HTree<K, V> tree) {
        super(tree);
    }

    public HashBucket(HTree<K, V> tree, int level) {
        super(tree);
        if (level > 4) {
            throw new IllegalArgumentException("Cannot create bucket with depth > MAX_DEPTH+1. Depth=" + level);
        }
        this._depth = level;
        this._keys = new ArrayList(8);
        this._values = new ArrayList(8);
    }

    public int getElementCount() {
        return this._keys.size();
    }

    public boolean isLeaf() {
        return this._depth > 3;
    }

    public boolean hasRoom() {
        if (this.isLeaf()) {
            return true;
        }
        return this._keys.size() < 8;
    }

    public V addElement(K key, V value) {
        int existing = this._keys.indexOf(key);
        if (existing != -1) {
            V before = this._values.get(existing);
            this._values.set(existing, value);
            return before;
        }
        this._keys.add(key);
        this._values.add(value);
        return null;
    }

    public V removeElement(K key) {
        int existing = this._keys.indexOf(key);
        if (existing != -1) {
            V obj = this._values.get(existing);
            this._keys.remove(existing);
            this._values.remove(existing);
            return obj;
        }
        return null;
    }

    public V getValue(K key) {
        int existing = this._keys.indexOf(key);
        if (existing != -1) {
            return this._values.get(existing);
        }
        return null;
    }

    ArrayList<K> getKeys() {
        return this._keys;
    }

    ArrayList<V> getValues() {
        return this._values;
    }

    public void writeExternal(SerializerOutput out) throws IOException {
        out.writePackedInt(this._depth);
        Serializer keySerializer = this.tree.getKeySerializer();
        if (keySerializer == null) {
            Serialization.writeObject(out, this._keys);
        } else {
            out.writePackedInt(this._keys.size());
            for (int i = 0; i < this._keys.size(); ++i) {
                K key = this._keys.get(i);
                if (key != null) {
                    out.writeBoolean(true);
                    keySerializer.serialize(out, key);
                    continue;
                }
                out.writeBoolean(false);
            }
        }
        Serializer valueSerializer = this.tree.getValueSerializer();
        for (int i = 0; i < this._keys.size(); ++i) {
            if (this._keys.get(i) == null) continue;
            if (valueSerializer == null) {
                Serialization.writeObject(out, this._values.get(i));
                continue;
            }
            valueSerializer.serialize(out, this._values.get(i));
        }
    }

    public void readExternal(SerializerInput in) throws IOException, ClassNotFoundException {
        int i;
        this._depth = in.readPackedInt();
        Serializer keySerializer = this.tree.getKeySerializer();
        if (keySerializer == null) {
            this._keys = (ArrayList)Serialization.readObject(in);
        } else {
            int size = in.readPackedInt();
            this._keys = new ArrayList(size);
            for (i = 0; i < size; ++i) {
                if (in.readBoolean()) {
                    this._keys.add(keySerializer.deserialize(in));
                    continue;
                }
                this._keys.add(null);
            }
        }
        Serializer valueSerializer = this.tree.getValueSerializer();
        this._values = new ArrayList(this._keys.size());
        for (i = 0; i < this._keys.size(); ++i) {
            if (this._keys.get(i) == null) {
                this._values.add(null);
                continue;
            }
            if (valueSerializer == null) {
                this._values.add(Serialization.readObject(in));
                continue;
            }
            this._values.add(valueSerializer.deserialize(in));
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("HashBucket {depth=");
        buf.append(this._depth);
        buf.append(", keys=");
        buf.append(this._keys);
        buf.append(", values=");
        buf.append(this._values);
        buf.append("}");
        return buf.toString();
    }
}

