
import logging
from pyvisdk.exceptions import InvalidArgumentError

########################################
# Automatically generated, do not edit.
########################################

log = logging.getLogger(__name__)

def TooManyConsecutiveOverrides(vim, *args, **kwargs):
    '''Thrown if there are too many consecutive user overrides of server-managed
    settings. There are some properties which users are allowed to set only in
    certain configurations. The system controls them in other configurations, and
    overrides all user updates. If there are such frequent user overrides in the
    system controlled state that the next update arrives before the previous
    override is complete, the system can enter a tight loop and appear unresponsive
    to the user. This would typically happen if the user overrides are generated by
    a script. If the number of such user overrides exceeds the supported maximum,
    we conceptually "throw" this fault. In practice, this is converted into a host-
    level ConfigIssue in VC.'''

    obj = vim.client.factory.create('{urn:vim25}TooManyConsecutiveOverrides')

    # do some validation checking...
    if (len(args) + len(kwargs)) < 4:
        raise IndexError('Expected at least 5 arguments got: %d' % len(args))

    required = [ 'dynamicProperty', 'dynamicType', 'faultCause', 'faultMessage' ]
    optional = [  ]

    for name, arg in zip(required+optional, args):
        setattr(obj, name, arg)

    for name, value in kwargs.items():
        if name in required + optional:
            setattr(obj, name, value)
        else:
            raise InvalidArgumentError("Invalid argument: %s.  Expected one of %s" % (name, ", ".join(required + optional)))

    return obj
