/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.pgx.api.internal.Entity;
import oracle.pgx.common.Link;
import oracle.pgx.common.PageableCollection;
import oracle.pgx.common.util.internal.DeserializationNotAllowed;

@JsonDeserialize(using=DeserializationNotAllowed.class)
public class PageableEntryCollection<K, V>
extends PageableCollection {
    private Boolean keyWrapped;
    private Boolean valueWrapped;

    public PageableEntryCollection() {
    }

    public PageableEntryCollection(Collection<Map.Entry<K, V>> items) {
        super(items);
        this.determineWrappings(items);
    }

    public PageableEntryCollection(Collection<Map.Entry<K, V>> items, List<Link> links) {
        super(items, links);
        this.determineWrappings(items);
    }

    public void setItems(Collection rawItems) {
        Collection items = rawItems;
        super.setItems(rawItems);
        this.determineWrappings(items);
    }

    @JsonSerialize(contentAs=Map.Entry.class)
    public Collection<?> getItems() {
        return super.getItems();
    }

    private void determineWrappings(Collection<Map.Entry<K, V>> items) {
        if (items == null || items.size() == 0) {
            this.setKeyWrapped(false);
            this.setValueWrapped(false);
            return;
        }
        Map.Entry<K, V> firstEntry = items.iterator().next();
        K firstKey = firstEntry.getKey();
        V firstValue = firstEntry.getValue();
        if (firstKey instanceof Entity) {
            this.setKeyWrapped(true);
        }
        if (firstValue instanceof Entity) {
            this.setValueWrapped(true);
        }
    }

    public Boolean isKeyWrapped() {
        return this.keyWrapped;
    }

    public void setKeyWrapped(Boolean keyWrapped) {
        this.keyWrapped = keyWrapped;
    }

    public Boolean isValueWrapped() {
        return this.valueWrapped;
    }

    public void setValueWrapped(Boolean valueWrapped) {
        this.valueWrapped = valueWrapped;
    }
}

