/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.types.internal;

import oracle.pgx.api.internal.Entity;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;

public final class IdTypeUtils {
    private IdTypeUtils() {
    }

    public static IdType getElementIdType(Object element) {
        if (element instanceof Entity) {
            Entity entity = (Entity)((Object)element);
            return entity.getIdType();
        }
        Class<?> firstElementClass = element.getClass();
        return IdType.getTypeFor(firstElementClass);
    }

    public static Object assertAndParseVertexId(String vertexId, IdType dstType, String errorMessage) {
        try {
            return dstType.parse(vertexId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)errorMessage, (Object[])new Object[0]), e);
        }
    }
}

