/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.loaders.location;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.pgx.common.ImmutablePair;
import oracle.pgx.common.util.SqlSanitizationUtils;
import oracle.pgx.config.Format;
import oracle.pgx.config.GraphOptimizedFor;
import oracle.pgx.config.OnMissingVertex;
import oracle.pgx.config.ReadGraphOption;
import oracle.pgx.config.SourceType;
import oracle.pgx.loaders.location.AbstractDatabaseGraphLocation;
import oracle.pgx.loaders.location.GraphLocation;

public class PgSqlGraphLocation
extends AbstractDatabaseGraphLocation {
    @JsonCreator
    public PgSqlGraphLocation(@JsonProperty(value="graphName") @Nonnull String graphName, @JsonProperty(value="schemaName") @Nullable String schemaName, @JsonProperty(value="optimizedFor") @Nullable GraphOptimizedFor optimizedFor, @JsonProperty(value="synchronizable") @Nullable Boolean synchronizable, @JsonProperty(value="onMissingVertex") @Nullable OnMissingVertex onMissingVertex, @JsonProperty(value="parallelHintDegree") @Nullable Integer parallelHintDegree, @JsonProperty(value="PropertyLoadingOption") @Nullable ReadGraphOption.PropertyLoadingOption propertyLoadingOption, @JsonProperty(value="jdbcUrl") @Nullable String jdbcUrl, @JsonProperty(value="username") @Nullable String username, @JsonProperty(value="password") @Nullable String password, @JsonProperty(value="dataSourceId") @Nullable String dataSourceId) {
        super(GraphLocation.GraphLocationType.PG_SQL_LOCATION, Format.PG, graphName, schemaName, parallelHintDegree, propertyLoadingOption, jdbcUrl, username, password, dataSourceId, optimizedFor, synchronizable, onMissingVertex);
    }

    public String getGraphName() {
        return this.sourceGraphName;
    }

    @Override
    public SourceType getGraphSourceType() {
        return SourceType.PG_SQL;
    }

    public static PgSqlGraphLocation fromQualifiedName(String schemaName, String graphName, List<ReadGraphOption> options) {
        return PgSqlGraphLocation.fromQualifiedName(schemaName, graphName, options, null, null, null, null);
    }

    public static PgSqlGraphLocation fromQualifiedName(String schemaName, String graphName, List<ReadGraphOption> options, String jdbcUrl, String username, String password, String dataSourceId) {
        ImmutablePair schemaAndName = SqlSanitizationUtils.parseSchemaAndName((String)schemaName, (String)graphName);
        ReadGraphOption.ReadGraphOptionDataBuilder optionBuilder = PgSqlGraphLocation.getOptionBuilder(options);
        return new PgSqlGraphLocation((String)schemaAndName.getSecond(), (String)schemaAndName.getFirst(), optionBuilder.getOptimizedFor(), optionBuilder.isSynchronizable(), optionBuilder.getOnMissingVertex(), optionBuilder.getParallelHintDegree(), optionBuilder.getPropertyLoadingOption(), jdbcUrl, username, password, dataSourceId);
    }
}

