/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.pgql.lang.PgqlException;
import oracle.pgx.api.Namespace;
import oracle.pgx.api.PgqlResultSet;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxResult;
import oracle.pgx.api.PgxSession;
import oracle.pgx.common.auth.AuthorizationException;
import oracle.pgx.common.types.IdType;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.graphviz.driver.PgxVisualQuery;
import oracle.pgx.graphviz.driver.exception.VisualQueryException;
import oracle.pgx.graphviz.driver.exception.VisualizationException;
import oracle.pgx.graphviz.driver.expandGraph.ExpandCondition;
import oracle.pgx.graphviz.driver.expandGraph.ExpandConditions;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.ConditionOperator;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.Parameter;
import org.apache.commons.lang3.math.NumberUtils;

public class PgxVisualizationUtils {
    protected static final Pattern escapePattern = Pattern.compile("'");
    protected static final Pattern arrayPattern = Pattern.compile("^\\[(.+)\\]$");
    protected static final Pattern edgesArrayPattern = Pattern.compile("(\\s?(\\[|\\]|,)\\s?)");
    protected static final Pattern formatPattern = Pattern.compile("^this\\.\\w+");
    protected static final Pattern replaceFormatPattern = Pattern.compile("^this\\.");
    protected static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    @Deprecated
    public static String getSmartExpandPgqlWhereClause(String prefix, ExpandConditions expandConditions, IdType idType) {
        List conditions = expandConditions.conditions;
        ArrayList<String> mappedConditions = new ArrayList<String>();
        for (ExpandCondition condition : conditions) {
            boolean isString;
            StringBuilder resultingString = new StringBuilder();
            String name = condition.component.equals("vertex") ? prefix + "v" : prefix + "e";
            String conditionOperator = ConditionOperator.validateOperator(condition.operator);
            String operator = conditionOperator.equals("!=") ? "<>" : conditionOperator;
            boolean bl = isString = condition.component.equals("vertex") && idType.equals((Object)IdType.STRING);
            if (condition.property.equals("id")) {
                resultingString.append(String.format("id( %s ) %s %s", name, operator, PgxVisualizationUtils.format(condition.value, isString)));
            } else if (condition.property.equals("label")) {
                resultingString.append(conditionOperator.equals("!=") ? "not " : "");
                resultingString.append("has_label(").append(name).append(", ").append(PgxVisualizationUtils.format(condition.value, isString)).append(")");
            } else {
                isString = !NumberUtils.isParsable((String)condition.value);
                resultingString.append(name);
                resultingString.append(String.format(".\"%s\" ", condition.property.replaceAll("\"", "\"\"")));
                resultingString.append(conditionOperator);
                resultingString.append(" ");
                resultingString.append(PgxVisualizationUtils.format(condition.value, isString));
            }
            mappedConditions.add(resultingString.toString());
        }
        return PgxVisualizationUtils.joiningConditions(mappedConditions, expandConditions.operator);
    }

    public static String format(String value, boolean isString) {
        if (formatPattern.matcher(value).find()) {
            return replaceFormatPattern.matcher(value).replaceAll("s.");
        }
        if (isString) {
            return String.format("'%s'", PgxVisualizationUtils.escapeLiteral(value));
        }
        return value;
    }

    public static String getExpandSourceCondition(String entity, String[] ids, IdType idType) {
        return String.format("id(%s) IN (%s)", entity, PgxVisualizationUtils.joiningIds(ids, idType));
    }

    public static String getExpandSourceCondition(String[] ids, IdType idType) {
        return String.format("(%s)", PgxVisualizationUtils.joiningIds(ids, idType));
    }

    private static String joiningIds(String[] ids, IdType idType) {
        Stream<String> idStream = Stream.of(ids);
        if (idType == IdType.STRING) {
            idStream = idStream.map(id -> "'" + PgxVisualizationUtils.escapeLiteral(id) + "'");
        }
        return idStream.collect(Collectors.joining(","));
    }

    private static String joiningConditions(List<String> conditions, String operator) {
        String join = "";
        switch (operator.toUpperCase()) {
            case "AND": {
                join = " AND ";
                break;
            }
            case "OR": {
                join = " OR ";
                break;
            }
            default: {
                throw new IllegalArgumentException("The condition operator is not well defined");
            }
        }
        return conditions.stream().map(Object::toString).collect(Collectors.joining(join));
    }

    public static String getReachabilityQueries(String[] ids, IdType idType, int hops) throws VisualizationException {
        if (hops > 3) {
            throw new VisualizationException("Number of hops must be strictly positive and less than 3");
        }
        StringBuilder sb = new StringBuilder("MATCH ");
        if (hops >= 1) {
            sb.append("(s)-[e]-(x)");
        }
        if (hops >= 2) {
            sb.append("-[e2]-(x2)");
        }
        if (hops == 3) {
            sb.append("-[e3]-(x3)");
        }
        sb.append(" WHERE id(s) IN ");
        sb.append(PgxVisualizationUtils.getExpandSourceCondition(ids, idType));
        return sb.toString();
    }

    public static String[] getEdgesIds(PgqlResultSet edgesResultSet) throws VisualizationException {
        HashSet<String> edgeIds = new HashSet<String>();
        for (PgxResult result : edgesResultSet) {
            Object resultObject;
            try {
                resultObject = result.getObject(1);
            }
            catch (PgqlException e) {
                throw new VisualizationException((Throwable)e);
            }
            if (resultObject == null) continue;
            for (String edgeId : PgxVisualizationUtils.getEdgesArray(resultObject.toString())) {
                edgeIds.add(edgeId);
            }
        }
        return edgeIds.toArray(new String[edgeIds.size()]);
    }

    public static String[] getEdgesArray(String resultString) {
        HashSet<String> items = new HashSet<String>();
        if (arrayPattern.matcher(resultString).matches()) {
            String[] array = edgesArrayPattern.split(resultString);
            for (int i = 1; i < array.length; ++i) {
                String edgeId = array[i];
                if (edgeId.isEmpty()) continue;
                items.add(array[i]);
            }
            return items.toArray(new String[items.size()]);
        }
        return new String[]{resultString};
    }

    public static String getExpandMatchClause(int hops) {
        String repeatedHops = "";
        while (hops > 1) {
            repeatedHops = String.format("%s()-", repeatedHops);
            --hops;
        }
        return String.format("(s)-%s[e]-()", repeatedHops);
    }

    @Deprecated
    public static String[] queryEdgeIds(PgxSession session, String edgesQuery) throws VisualizationException {
        PgqlResultSet edgesResultSet;
        try {
            edgesResultSet = session.queryPgql(edgesQuery);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new VisualizationException(String.format("Failed query '%s'", edgesQuery), (Throwable)e);
        }
        return PgxVisualizationUtils.getEdgesIds(edgesResultSet);
    }

    public static PgxGraph getGraphFromPgqlGraphRef(PgxSession session, String pgqlGraphRef) throws VisualizationException {
        Namespace[] namespaceOrder = new Namespace[]{Namespace.PRIVATE, Namespace.PUBLIC};
        boolean matchCaseInsensitive = pgqlGraphRef.equals(pgqlGraphRef.toUpperCase());
        try {
            for (Namespace namespace : namespaceOrder) {
                List graphNamesInNamespace = session.getGraphs(namespace);
                if (graphNamesInNamespace.contains(pgqlGraphRef)) {
                    return session.getGraph(namespace, pgqlGraphRef);
                }
                if (!matchCaseInsensitive) continue;
                for (String graphName : graphNamesInNamespace) {
                    if (!graphName.toUpperCase().equals(pgqlGraphRef)) continue;
                    return session.getGraph(namespace, graphName);
                }
            }
            throw new VisualizationException(String.format("Could not find Graph '%s'", pgqlGraphRef));
        }
        catch (InterruptedException | ExecutionException e) {
            Exception cause;
            if (Objects.nonNull(e) && Objects.nonNull(e.getCause()) && (cause = (Exception)e.getCause()).getClass() == AuthorizationException.class) {
                throw new VisualizationException((Throwable)e);
            }
            throw new VisualizationException((Throwable)e);
        }
    }

    @Deprecated
    public static String queryPgql(PgxVisualQuery visualQuery, String query) throws VisualizationException {
        try {
            return visualQuery.queryPgql(query);
        }
        catch (IOException | SQLException | PgqlException e) {
            throw new VisualizationException(String.format("Failed query '%s'", query), e);
        }
    }

    public static String queryPgql(PgxVisualQuery visualQuery, PgxGraph graph, String query, List<Parameter<?>> parameters) throws VisualizationException {
        try {
            return visualQuery.queryPgql(graph, query, parameters);
        }
        catch (VisualQueryException e) {
            throw new VisualizationException(String.format("Failed to execute the pgx prepared statement query: '%s'", query), (Throwable)e);
        }
    }

    private static String escapeLiteral(String value) {
        return escapePattern.matcher(value).replaceAll("''");
    }

    public static boolean isOffloadedSubgraph(PgxGraph graph) {
        GraphConfig config = graph.getConfig();
        if (!(config instanceof PartitionedGraphConfig)) {
            return false;
        }
        PartitionedGraphConfig partitionedConfig = (PartitionedGraphConfig)config;
        return (partitionedConfig.getSourceName() != null && partitionedConfig.getSourceType() != null || partitionedConfig.getPgViewName() != null) && (partitionedConfig.getQueries() != null || partitionedConfig.getPreparedQueries() != null);
    }
}

