/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver.pgxPreparedStatement;

import java.util.Arrays;

public enum ConditionOperator {
    LESS("<"),
    LESS_OR_EQUAL("<="),
    GREATER(">"),
    GREATER_OR_EQUAL(">="),
    EQUAL("="),
    NOT_EQUAL("!=");

    String operator;

    private ConditionOperator(String operator) {
        this.operator = operator;
    }

    public static String validateOperator(String operator) {
        if (Arrays.stream(ConditionOperator.values()).filter(op -> op.operator.equals(operator)).count() > 0L) {
            return operator;
        }
        throw new IllegalArgumentException(String.format("The condition operator '%s' is not well defined", operator));
    }
}

