/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters;

import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.spatial.Point2D;
import oracle.pgx.api.PgxPreparedStatement;
import oracle.pgx.common.GmParseException;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.graphviz.driver.exception.VisualizationException;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.BooleanParameter;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.DoubleParameter;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.FloatParameter;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.IntegerParameter;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.LocalDateParameter;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.LongParameter;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.Point2DParameter;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.StringParameter;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.TimeParameter;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.TimeWithTimezoneParameter;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.TimestampParameter;
import oracle.pgx.graphviz.driver.pgxPreparedStatement.parameters.TimestampWithTimezoneParameter;

public abstract class Parameter<T> {
    protected int index;
    protected T value;

    public Parameter(int index, T value) {
        this.index = index;
        this.value = value;
    }

    public Parameter(int index, String value, IdType type) {
        this.index = index;
        this.value = type.parse(value);
    }

    public Parameter(int index, String value, PropertyType type) throws VisualizationException {
        this.index = index;
        try {
            this.value = type.parse(value);
        }
        catch (GmParseException e) {
            throw new VisualizationException(String.format("Cannot parse the parameter '%s' of type '%s'", value, type), (Throwable)e);
        }
    }

    public T getValue() {
        return this.value;
    }

    public abstract void bindValue(PgxPreparedStatement var1) throws PgqlException;

    public static Parameter<?> createParameter(String stringValue, IdType type, int index) throws VisualizationException {
        switch (type) {
            case STRING: {
                return new StringParameter(index, stringValue);
            }
            case INTEGER: {
                return new IntegerParameter(index, stringValue, type);
            }
            case LONG: {
                return new LongParameter(index, stringValue, type);
            }
        }
        throw new VisualizationException(String.format("The type '%s' of the parameter '%s' is not well defined", type, stringValue));
    }

    public static Parameter<?> createParameter(String stringValue, PropertyType type, int index) throws VisualizationException {
        switch (type) {
            case BOOLEAN: {
                return new BooleanParameter(index, stringValue, type);
            }
            case DOUBLE: {
                return new DoubleParameter(index, stringValue, type);
            }
            case FLOAT: {
                return new FloatParameter(index, stringValue, type);
            }
            case INTEGER: {
                return new IntegerParameter(index, stringValue, type);
            }
            case LOCAL_DATE: {
                return new LocalDateParameter(index, stringValue, type);
            }
            case LONG: {
                return new LongParameter(index, stringValue, type);
            }
            case POINT2D: {
                return new Point2DParameter(index, Point2D.fromWkt((String)stringValue));
            }
            case STRING: {
                return new StringParameter(index, stringValue);
            }
            case TIME: {
                return new TimeParameter(index, stringValue, type);
            }
            case TIMESTAMP: {
                return new TimestampParameter(index, stringValue, type);
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return new TimestampWithTimezoneParameter(index, stringValue, type);
            }
            case TIME_WITH_TIMEZONE: {
                return new TimeWithTimezoneParameter(index, stringValue, type);
            }
        }
        throw new VisualizationException(String.format("The type '%s' of the parameter %s is not well defined", type, stringValue));
    }
}

