/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.executionenvironment;

import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AnalysisTaskConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.EnterpriseSchedulerConfig;
import oracle.pgx.config.PgxConfig;
import oracle.pgx.validation.IsPositiveOrNullValidator;
import oracle.pgx.validation.Validator;

public enum ExecutionEnvironmentField {
    NUM_THREADS_PER_TASK((ConfigField)EnterpriseSchedulerConfig.Field.NUM_IO_THREADS_PER_TASK, new Validator[]{IsPositiveOrNullValidator.IS_POSITIVE_INTEGER}),
    WEIGHT((ConfigField)AnalysisTaskConfig.Field.WEIGHT, new Validator[]{IsPositiveOrNullValidator.IS_POSITIVE_INTEGER}),
    PRIORITY((ConfigField)AnalysisTaskConfig.Field.PRIORITY, new Validator[0]),
    MAX_NUM_THREADS((ConfigField)AnalysisTaskConfig.Field.MAX_THREADS, new Validator[]{IsPositiveOrNullValidator.IS_POSITIVE_INTEGER}),
    UPDATE_CONSISTENCY_MODEL((ConfigField)PgxConfig.Field.IN_PLACE_UPDATE_CONSISTENCY_MODEL, new Validator[0]),
    ALLOW_MULTIPLE_CONCURRENT_TASKS(Boolean.class, new Validator[0]);

    private final ConfigField field;
    private final Validator[] validators;
    private final Class<?> type;

    private ExecutionEnvironmentField(ConfigField field, Validator ... validators) {
        this.field = field;
        this.validators = validators;
        this.type = field.getType();
    }

    private ExecutionEnvironmentField(Class<?> type, Validator ... validators) {
        this.field = null;
        this.validators = validators;
        this.type = type;
    }

    public boolean isPoolBound() {
        switch (this) {
            case NUM_THREADS_PER_TASK: 
            case WEIGHT: 
            case PRIORITY: 
            case MAX_NUM_THREADS: {
                return true;
            }
            case UPDATE_CONSISTENCY_MODEL: 
            case ALLOW_MULTIPLE_CONCURRENT_TASKS: {
                return false;
            }
        }
        throw new IllegalEnumConstantException((Enum)this);
    }

    public <T extends ConfigField> T getField(Class<T> expectedClass) {
        if (this.field == null) {
            return null;
        }
        if (!this.field.getClass().isAssignableFrom(expectedClass)) {
            ErrorMessages.throwException(IllegalArgumentException::new, (String)"INVALID_EXECUTION_ENVIRONMENT_CONFIG_FIELD", (Object[])new Object[]{expectedClass, this});
        }
        return (T)((ConfigField)expectedClass.cast(this.field));
    }

    public ConfigField getField() {
        return this.field;
    }

    public void checkType(Object o) {
        Class<?> givenType;
        if (o == null) {
            return;
        }
        Class<?> expectedType = this.getType();
        if (!expectedType.isAssignableFrom(givenType = o.getClass())) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNEXPECTED_TYPE", (Object[])new Object[]{expectedType, givenType}));
        }
    }

    public void verify(Object value) {
        this.checkType(value);
        for (Validator validator : this.validators) {
            validator.validate(value, this.name());
        }
    }

    public Class<?> getType() {
        return this.type;
    }
}

