/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.synchronizer;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.internal.synchronizer.FlashbackConfig;
import oracle.pgx.api.internal.synchronizer.FlashbackConfigBuilder;
import oracle.pgx.api.internal.synchronizer.FlashbackPropertyConfig;
import oracle.pgx.api.internal.synchronizer.GraphPropertyDefinitions;
import oracle.pgx.api.keys.ForeignKeyColumnDescriptor;
import oracle.pgx.api.keys.KeyColumnDescriptor;
import oracle.pgx.api.keys.KeyUtils;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.RdbmsEntityProviderConfig;

public final class FetcherUtils {
    private static final int SCN_EXPIRED_ERROR = 30052;
    private static final int TABLE_OR_VIEW_NOT_EXISTS_ERROR = 942;
    private static final int VERSIONS_CLAUSE_NOT_ALLOWED = 30051;
    private final GraphPropertyDefinitions additionalPropertyDefinitions;
    private final Long currentScn;

    public FetcherUtils(Long currentScn) {
        this(currentScn, null);
    }

    public FetcherUtils(Long currentScn, GraphPropertyDefinitions additionalPropertyDefinitions) {
        this.currentScn = currentScn;
        this.additionalPropertyDefinitions = additionalPropertyDefinitions;
    }

    public FlashbackConfig createFlashbackConfig(PgxGraph g, EntityProviderConfig provider, Long lastScn, Integer parallelHintDegree) {
        RdbmsEntityProviderConfig rdbmsConfig = (RdbmsEntityProviderConfig)provider;
        String providerName = provider.getName();
        List<FlashbackPropertyConfig> properties = provider.getProps().stream().map(p -> this.createPropertyConfig(providerName, (GraphPropertyConfig)p)).collect(Collectors.toList());
        return new FlashbackConfigBuilder().setProperties(properties).setTableName(rdbmsConfig.getDatabaseTableName()).setUsername(rdbmsConfig.getUsername()).setGraphName(g.getName()).setStartScn(lastScn).setEndScn(this.currentScn).setKeyColumn(((KeyColumnDescriptor)KeyUtils.getSingleKeyColumn((List)rdbmsConfig.getValidatedKeyColumns())).getName()).setSourceColumn(((ForeignKeyColumnDescriptor)KeyUtils.getSingleKeyColumn((List)rdbmsConfig.getValidatedSourceKeyColumns())).getName()).setDestinationColumn(((ForeignKeyColumnDescriptor)KeyUtils.getSingleKeyColumn((List)rdbmsConfig.getValidatedDestinationKeyColumns())).getName()).setSchema(rdbmsConfig.getSchema()).setDop(parallelHintDegree).build();
    }

    private FlashbackPropertyConfig createPropertyConfig(String providerName, GraphPropertyConfig propertyConfig) {
        String propertyName = propertyConfig.getName();
        String column = (String)propertyConfig.getColumn();
        if (column != null || this.additionalPropertyDefinitions == null) {
            return FlashbackPropertyConfig.fromColumnName(propertyName, column);
        }
        String definition = this.additionalPropertyDefinitions.getPropertyDefinition(providerName, propertyName);
        return FlashbackPropertyConfig.fromColumnExpression(propertyName, definition);
    }

    public static void rethrowSqlException(SQLException ex, String tableName) throws SQLException {
        switch (ex.getErrorCode()) {
            case 30051: {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"VIEWS_NOT_SUPPORTED", (Object[])new Object[]{tableName}), ex);
            }
            case 30052: {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"SYNC_SCN_TIMEOUT_EXCEPTION", (Object[])new Object[0]), ex);
            }
            case 942: {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"TABLE_OR_VIEW_NOT_EXISTS", (Object[])new Object[]{tableName}), ex);
            }
        }
        throw ex;
    }
}

