/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.imports.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import oracle.pg.imports.db.ConnectionManager;
import oracle.pg.imports.db.SqlTable;
import oracle.pg.imports.exceptions.GraphImportException;
import oracle.pg.imports.parser.ReaderResult;
import oracle.pg.imports.parser.graphson.GraphsonDataTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Batch
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(Batch.class);
    private final ConnectionManager connectionManager;
    private final ReaderResult tables;
    private final Set<String> createdTables;
    private final int stringFieldsSize;
    private final short fractionalSecondsPrecision;

    public Batch(ConnectionManager connectionManager, ReaderResult tables, Set<String> createdTables, int stringFieldsSize, short fractionalSecondsPrecision) {
        this.connectionManager = connectionManager;
        this.tables = tables;
        this.createdTables = createdTables;
        this.stringFieldsSize = stringFieldsSize;
        this.fractionalSecondsPrecision = fractionalSecondsPrecision;
    }

    @Override
    public Void call() throws SQLException, GraphImportException {
        this.addVertices();
        this.addEdges();
        return null;
    }

    private void addVertices() throws SQLException, GraphImportException {
        Map<String, SqlTable> vertices = this.tables.getVertices();
        for (String label : vertices.keySet()) {
            SqlTable table = vertices.get(label);
            this.validateAndCreateTable(table.getName(), table.getProperties());
            this.buildInsertStmts(table.getName(), table.getData());
        }
    }

    private void addEdges() throws SQLException, GraphImportException {
        Map<String, SqlTable> edges = this.tables.getEdges();
        for (String label : edges.keySet()) {
            SqlTable table = edges.get(label);
            this.validateAndCreateTable(table.getName(), table.getProperties());
            this.buildEdgesInsertStmts(table.getName(), table.getData());
        }
    }

    private void createNewTable(String tableName, Map<String, GraphsonDataTypes> columns) throws GraphImportException, SQLException {
        StringBuilder createStmt = new StringBuilder("CREATE TABLE ").append(tableName).append(" (");
        String comma = "";
        for (String colName : columns.keySet()) {
            GraphsonDataTypes colType = columns.get(colName);
            String colTypeStr = this.toDbType(colType, colName);
            createStmt.append(comma).append(" ").append(colName).append(" ").append(colTypeStr);
            comma = ",";
        }
        createStmt.append(", PRIMARY KEY (").append("id").append("))");
        try (Connection connection = this.connectionManager.getConnection();
             PreparedStatement stmt = connection.prepareStatement(createStmt.toString());){
            stmt.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateAndCreateTable(String tableName, Map<String, GraphsonDataTypes> properties) throws SQLException, GraphImportException {
        Set<String> set = this.createdTables;
        synchronized (set) {
            if (this.createdTables.contains(tableName)) {
                return;
            }
            LOG.debug("Creating table {} ...", (Object)tableName);
            this.createNewTable(tableName, properties);
            this.createdTables.add(tableName);
            LOG.debug("... Table {} created", (Object)tableName);
        }
    }

    private void buildInsertStmts(String tableName, List<Map<String, Object>> rows) throws SQLException {
        StringBuilder insert = new StringBuilder("INSERT INTO ").append(tableName).append(" (");
        StringBuilder binds = new StringBuilder();
        String comma = "";
        for (String colName : rows.get(0).keySet()) {
            insert.append(comma).append(colName);
            binds.append(comma).append("?");
            comma = ",";
        }
        insert.append(" ) VALUES ( ").append((CharSequence)binds).append(" )");
        try (Connection connection = this.connectionManager.getConnection();
             PreparedStatement stmt = connection.prepareStatement(insert.toString());){
            for (Map<String, Object> row : rows) {
                int colNum = 1;
                for (String colName : row.keySet()) {
                    stmt.setObject(colNum++, row.get(colName));
                }
                stmt.addBatch();
            }
            LOG.debug("Inserting batch vertices ...");
            stmt.executeBatch();
            LOG.debug("... Done inserting batch vertices");
        }
    }

    private void buildEdgesInsertStmts(String tableName, List<Map<String, Object>> rows) throws SQLException {
        StringBuilder insert = new StringBuilder("INSERT INTO ").append(tableName).append(" (");
        StringBuilder binds = new StringBuilder();
        String comma = "";
        for (String colName : rows.get(0).keySet()) {
            insert.append(comma).append(" ").append(colName);
            binds.append(comma).append(" ").append("?");
            comma = ",";
        }
        insert.append(" ) VALUES (").append((CharSequence)binds).append(" )");
        try (Connection connection = this.connectionManager.getConnection();
             PreparedStatement stmt = connection.prepareStatement(insert.toString());){
            for (Map<String, Object> row : rows) {
                int colNum = 1;
                for (String colName : row.keySet()) {
                    stmt.setObject(colNum, row.get(colName));
                    ++colNum;
                }
                stmt.addBatch();
            }
            LOG.debug("Inserting batch edges ...");
            stmt.executeBatch();
            LOG.debug("... Done inserting batch edges");
        }
    }

    private String toDbType(GraphsonDataTypes colType, String colName) throws GraphImportException {
        switch (colType) {
            case G_DOUBLE: 
            case G_FLOAT: {
                return "FLOAT";
            }
            case G_INT32: {
                return "NUMBER(10)";
            }
            case G_INT64: {
                return "NUMBER(19)";
            }
            case G_DATE: {
                return "DATE";
            }
            case G_TIMESTAMP: {
                return "TIMESTAMP(" + this.fractionalSecondsPrecision + ")";
            }
            case G_UUID: {
                return "CHAR(36) CHECK (REGEXP_LIKE(" + colName + ", '^[0-9a-fA-F]{8}-([0-9a-fA-F]{4}-){3}[0-9a-fA-F]{12}$'))";
            }
            case G_STRING: {
                return "VARCHAR2(" + this.stringFieldsSize + ")";
            }
        }
        throw new GraphImportException(String.format("Type %s not supported", new Object[]{colType}));
    }
}

