/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.util.Map;
import mb.flowspec.controlflow.TransferFunctionAppl;
import mb.flowspec.runtime.interpreter.Context;
import mb.flowspec.runtime.interpreter.Types;
import mb.flowspec.runtime.interpreter.Where;
import mb.flowspec.runtime.interpreter.locals.ArgToVarNode;
import mb.flowspec.terms.TermIndexed;
import org.metaborg.util.tuple.Tuple2;
import org.spoofax.interpreter.terms.IStrategoTerm;

@TypeSystemReference(value=Types.class)
public class TransferFunction
extends RootNode {
    private ArgToVarNode[] patternVariables;
    private Where body;

    public TransferFunction(FrameDescriptor frameDescriptor, ArgToVarNode[] patternVariables, Where body) {
        this(null, frameDescriptor, patternVariables, body);
    }

    public TransferFunction(TruffleLanguage<Context> language, FrameDescriptor frameDescriptor, ArgToVarNode[] patternVariables, Where body) {
        super(language, frameDescriptor);
        this.patternVariables = patternVariables;
        this.body = body;
    }

    public Object execute(VirtualFrame frame) {
        ArgToVarNode[] argToVarNodeArray = this.patternVariables;
        int n = this.patternVariables.length;
        int n2 = 0;
        while (n2 < n) {
            ArgToVarNode pv = argToVarNodeArray[n2];
            pv.execute(frame);
            ++n2;
        }
        return this.body.execute(frame);
    }

    public IStrategoTerm call(TransferFunctionAppl appl, IStrategoTerm currentNode) {
        try {
            return Types.expectIStrategoTerm(Truffle.getRuntime().createCallTarget((RootNode)this).call((Object[])appl.args(TermIndexed.excludeTermIndexFromEqual(currentNode))));
        }
        catch (UnexpectedResultException e) {
            throw new RuntimeException(e);
        }
    }

    public static TransferFunction findFunction(Map<Tuple2<String, Integer>, TransferFunction> tfs, TransferFunctionAppl appl) {
        return tfs.get(Tuple2.of(appl.moduleName(), appl.offset()));
    }
}

