/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.sym;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.sym.ACGoal;
import mb.nabl2.terms.ITerm;

public final class CGoal
extends ACGoal
implements Serializable {
    private final ITerm goal;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CGoal(ITerm goal, IMessageInfo messageInfo) {
        this.goal = Objects.requireNonNull(goal, "goal");
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CGoal(CGoal original, ITerm goal, IMessageInfo messageInfo) {
        this.goal = goal;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getGoal() {
        return this.goal;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CGoal withGoal(ITerm value) {
        if (this.goal == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "goal");
        return new CGoal(this, newValue, this.messageInfo);
    }

    public final CGoal withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CGoal(this, this.goal, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CGoal && this.equalTo(0, (CGoal)another);
    }

    private boolean equalTo(int synthetic, CGoal another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.goal.equals(another.goal) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.goal.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CGoal of(ITerm goal, IMessageInfo messageInfo) {
        return new CGoal(goal, messageInfo);
    }

    public static CGoal copyOf(ACGoal instance) {
        if (instance instanceof CGoal) {
            return (CGoal)instance;
        }
        return CGoal.of(instance.getGoal(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CGoal(this, this.goal, this.messageInfo);
    }
}

