/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver;

import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.solver.ISolver;
import mb.nabl2.solver.messages.IMessages;

public final class SeedResult
extends ISolver.ASeedResult
implements Serializable {
    private final Set.Immutable<IConstraint> constraints;
    private final IMessages.Immutable messages;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final long serialVersionUID = 42L;

    private SeedResult(Builder builder) {
        if (builder.constraints != null) {
            this.initShim.constraints((Set.Immutable<IConstraint>)builder.constraints);
        }
        if (builder.messages != null) {
            this.initShim.messages(builder.messages);
        }
        this.constraints = this.initShim.constraints();
        this.messages = this.initShim.messages();
        this.initShim = null;
    }

    private SeedResult(Set.Immutable<IConstraint> constraints, IMessages.Immutable messages) {
        this.constraints = constraints;
        this.messages = messages;
        this.initShim = null;
    }

    @Override
    public Set.Immutable<IConstraint> constraints() {
        InitShim shim = this.initShim;
        return shim != null ? shim.constraints() : this.constraints;
    }

    @Override
    public IMessages.Immutable messages() {
        InitShim shim = this.initShim;
        return shim != null ? shim.messages() : this.messages;
    }

    public final SeedResult withConstraints(Set.Immutable<IConstraint> value) {
        if (this.constraints == value) {
            return this;
        }
        Set.Immutable<IConstraint> newValue = Objects.requireNonNull(value, "constraints");
        return new SeedResult(newValue, this.messages);
    }

    public final SeedResult withMessages(IMessages.Immutable value) {
        if (this.messages == value) {
            return this;
        }
        IMessages.Immutable newValue = Objects.requireNonNull(value, "messages");
        return new SeedResult(this.constraints, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SeedResult && this.equalTo(0, (SeedResult)another);
    }

    private boolean equalTo(int synthetic, SeedResult another) {
        return this.constraints.equals(another.constraints) && this.messages.equals(another.messages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.constraints.hashCode();
        h += (h << 5) + this.messages.hashCode();
        return h;
    }

    public String toString() {
        return "SeedResult{constraints=" + this.constraints + ", messages=" + this.messages + "}";
    }

    public static SeedResult copyOf(ISolver.ASeedResult instance) {
        if (instance instanceof SeedResult) {
            return (SeedResult)instance;
        }
        return SeedResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ SeedResult(Builder builder, SeedResult seedResult) {
        this(builder);
    }

    public static final class Builder {
        private Set.Immutable<IConstraint> constraints;
        private IMessages.Immutable messages;

        private Builder() {
        }

        public final Builder from(ISolver.ASeedResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.constraints(instance.constraints());
            this.messages(instance.messages());
            return this;
        }

        public final Builder constraints(Set.Immutable<IConstraint> constraints) {
            this.constraints = Objects.requireNonNull(constraints, "constraints");
            return this;
        }

        public final Builder messages(IMessages.Immutable messages) {
            this.messages = Objects.requireNonNull(messages, "messages");
            return this;
        }

        public SeedResult build() {
            return new SeedResult(this, null);
        }
    }

    private final class InitShim {
        private byte constraintsBuildStage = 0;
        private Set.Immutable<IConstraint> constraints;
        private byte messagesBuildStage = 0;
        private IMessages.Immutable messages;

        private InitShim() {
        }

        Set.Immutable<IConstraint> constraints() {
            if (this.constraintsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.constraintsBuildStage == 0) {
                this.constraintsBuildStage = (byte)-1;
                this.constraints = Objects.requireNonNull(SeedResult.super.constraints(), "constraints");
                this.constraintsBuildStage = 1;
            }
            return this.constraints;
        }

        void constraints(Set.Immutable<IConstraint> constraints) {
            this.constraints = constraints;
            this.constraintsBuildStage = 1;
        }

        IMessages.Immutable messages() {
            if (this.messagesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.messagesBuildStage == 0) {
                this.messagesBuildStage = (byte)-1;
                this.messages = Objects.requireNonNull(SeedResult.super.messages(), "messages");
                this.messagesBuildStage = 1;
            }
            return this.messages;
        }

        void messages(IMessages.Immutable messages) {
            this.messages = messages;
            this.messagesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.constraintsBuildStage == -1) {
                attributes.add("constraints");
            }
            if (this.messagesBuildStage == -1) {
                attributes.add("messages");
            }
            return "Cannot build SeedResult, attribute initializers form cycle " + attributes;
        }
    }
}

