/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import mb.pie.api.ExecContext;
import mb.pie.api.Function;
import mb.pie.api.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FlatMappedSupplier<T extends Serializable, R extends Serializable>
implements Supplier<R> {
    private final Supplier<T> supplier;
    private final Function<? super T, Supplier<R>> func;

    public FlatMappedSupplier(Supplier<T> supplier, Function<? super T, Supplier<R>> func) {
        this.supplier = supplier;
        this.func = func;
    }

    @Override
    public R get(ExecContext context) {
        return this.func.apply(context, this.supplier.get(context)).get(context);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlatMappedSupplier mappedSupplier = (FlatMappedSupplier)o;
        if (!this.supplier.equals(mappedSupplier.supplier)) {
            return false;
        }
        return this.func.equals(mappedSupplier.func);
    }

    public int hashCode() {
        int result = this.supplier.hashCode();
        result = 31 * result + this.func.hashCode();
        return result;
    }

    public String toString() {
        return "MappedSupplier(" + this.supplier + ", " + this.func + ")";
    }
}

