/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api.stamp.resource;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.stream.Stream;
import mb.resource.ReadableResource;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.match.ResourceMatcher;
import mb.resource.hierarchical.walk.ResourceWalker;
import org.checkerframework.checker.nullness.qual.Nullable;

class Modified {
    Modified() {
    }

    static long modified(ReadableResource resource) throws IOException {
        if (!resource.exists()) {
            return Modified.getMaximum();
        }
        return Modified.modifiedResource(resource);
    }

    static long modified(HierarchicalResource resource, @Nullable ResourceMatcher matcher) throws IOException {
        if (!resource.exists()) {
            return Modified.getMaximum();
        }
        if (resource.isFile()) {
            return Modified.modifiedResource(resource);
        }
        if (resource.isDirectory()) {
            return Modified.modifiedDir(resource, matcher);
        }
        return Modified.getMinimum();
    }

    static long modifiedRec(HierarchicalResource resource, @Nullable ResourceWalker walker, @Nullable ResourceMatcher matcher) throws IOException {
        if (!resource.exists()) {
            return Modified.getMaximum();
        }
        if (resource.isFile()) {
            return Modified.modifiedResource(resource);
        }
        if (resource.isDirectory()) {
            return Modified.modifiedDirRec(resource, walker, matcher);
        }
        return Modified.getMinimum();
    }

    private static long modifiedResource(ReadableResource resource) throws IOException {
        return resource.getLastModifiedTime().toEpochMilli();
    }

    private static long modifiedDir(HierarchicalResource dir, @Nullable ResourceMatcher matcher) throws IOException {
        long[] lastModified = new long[]{Modified.getMinimum()};
        boolean useMatcher = matcher != null;
        try (Stream<? extends HierarchicalResource> stream = useMatcher ? dir.list(matcher) : dir.list();){
            stream.forEach(resource -> {
                try {
                    long modified = Modified.modifiedResource(resource);
                    lastModified[0] = Math.max(lastModified[0], modified);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        return lastModified[0];
    }

    private static long modifiedDirRec(HierarchicalResource dir, @Nullable ResourceWalker walker, @Nullable ResourceMatcher matcher) throws IOException {
        long[] lastModified = new long[]{Modified.getMinimum()};
        boolean useWalker = walker != null && matcher != null;
        try (Stream<? extends HierarchicalResource> stream = useWalker ? dir.walk(walker, matcher) : dir.walk();){
            stream.forEach(resource -> {
                try {
                    long modified = Modified.modifiedResource(resource);
                    lastModified[0] = Math.max(lastModified[0], modified);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        return lastModified[0];
    }

    private static long getMinimum() {
        return Long.MIN_VALUE;
    }

    private static long getMaximum() {
        return Long.MAX_VALUE;
    }
}

