/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match.path;

import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.match.path.PathMatcher;
import mb.resource.util.AntPattern;
import mb.resource.util.SeparatorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AntPatternPathMatcher
implements PathMatcher {
    private final AntPattern pattern;

    public AntPatternPathMatcher(AntPattern pattern) {
        this.pattern = pattern;
    }

    public AntPatternPathMatcher(String pattern) {
        this(new AntPattern(pattern));
    }

    @Override
    public boolean matches(ResourcePath path, ResourcePath rootDir) {
        String relative = SeparatorUtil.convertCurrentToUnixSeparator(rootDir.relativize(path));
        return this.pattern.match(relative);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AntPatternPathMatcher that = (AntPatternPathMatcher)o;
        return this.pattern.equals(that.pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public String toString() {
        return "with-ant-pattern(" + this.pattern + ")";
    }
}

