/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.ecoop21;

import io.usethesource.capsule.Set;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mb.scopegraph.ecoop21.INameResolutionContext;
import mb.scopegraph.ecoop21.LabelOrder;
import mb.scopegraph.ecoop21.LabelWf;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.oopsla20.reference.Env;
import mb.scopegraph.oopsla20.terms.newPath.ResolutionPath;
import mb.scopegraph.oopsla20.terms.newPath.ScopePath;
import org.metaborg.util.Ref;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.Futures;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.unit.Unit;

public class NameResolution<S, L, D, M> {
    private static final ILogger logger = LoggerUtils.logger(NameResolution.class);
    private final EdgeOrData<L> dataLabel = EdgeOrData.data();
    private final Set.Immutable<L> edgeLabels;
    private final LabelOrder<L> labelOrder;
    private final INameResolutionContext<S, L, D, M> context;

    public NameResolution(Set.Immutable<L> edgeLabels, LabelOrder<L> labelOrder, INameResolutionContext<S, L, D, M> context) {
        this.edgeLabels = edgeLabels;
        this.labelOrder = labelOrder;
        this.context = context;
    }

    public IFuture<Tuple2<Env<S, L, D>, M>> env(ScopePath<S, L> path, LabelWf<L> re, ICancel cancel) {
        Set.Transient labels = CapsuleUtil.transientSet();
        if (re.accepting()) {
            labels.__insert(this.dataLabel);
        }
        for (Object l : this.edgeLabels) {
            if (!re.step(l).isPresent()) continue;
            labels.__insert(EdgeOrData.edge(l));
        }
        return this.env_L(path, re, labels.freeze(), cancel);
    }

    private IFuture<Tuple2<Env<S, L, D>, M>> env_L(ScopePath<S, L> path, LabelWf<L> re, Set.Immutable<EdgeOrData<L>> L2, ICancel cancel) {
        logger.trace("env_L {} {} {}", path, re, L2);
        if (cancel.cancelled()) {
            return CompletableFuture.completedExceptionally(new InterruptedException());
        }
        Set.Immutable<EdgeOrData<L>> max_L = this.max(L2);
        ArrayList<IFuture<Tuple2<Env<S, L, D>, M>>> envs = new ArrayList<IFuture<Tuple2<Env<S, L, D>, M>>>();
        for (EdgeOrData l : max_L) {
            envs.add(this.env_lL(path, re, l, this.smaller(L2, l), cancel));
        }
        IFuture<List<List>> listEnv = AggregateFuture.of(envs);
        logger.trace("env_L {} {} {}: listEnv: {}", path, re, L2, listEnv);
        listEnv.whenComplete((r, ex) -> logger.trace("env_L {} {} {}: listResult {}", path, re, L2, listEnv));
        IFuture env = listEnv.thenApply(es -> {
            Env.Builder envBuilder = Env.builder();
            M metadata = this.context.unitMetadata();
            for (Tuple2 e : es) {
                envBuilder.addAll((Iterable)e._1());
                metadata = this.context.compose(metadata, e._2());
            }
            return Tuple2.of(envBuilder.build(), metadata);
        });
        logger.trace("env_L {} {} {}: env: {}", path, re, L2, env);
        env.whenComplete((r, ex) -> logger.trace("env_L {} {} {}: result {}", path, re, L2, env));
        return env;
    }

    private IFuture<Tuple2<Env<S, L, D>, M>> env_lL(ScopePath<S, L> path, LabelWf<L> re, EdgeOrData<L> l, Set.Immutable<EdgeOrData<L>> L2, ICancel cancel) {
        IFuture<Tuple2<Env<S, L, D>, M>> env1 = this.env_L(path, re, L2, cancel);
        logger.trace("env_lL {} {} {}: env1: {}", path, re, L2, env1);
        env1.whenComplete((r, ex) -> logger.trace("env_lL {} {} {}: result1: {}", path, re, L2, r));
        return env1.thenCompose(e1 -> {
            IFuture<Boolean> envComplete = ((Env)e1._1()).isEmpty() ? CompletableFuture.completedFuture(false) : this.context.dataLeqAlwaysTrue(cancel);
            return envComplete.thenCompose(complete -> {
                if (complete.booleanValue()) {
                    logger.trace("env_lL {} {} {}: env2 fully shadowed", path, re, L2);
                    return CompletableFuture.completedFuture(e1);
                }
                IFuture<Tuple2<Env<S, L, D>, M>> env2 = this.env_l(path, re, l, cancel);
                logger.trace("env_lL {} {} {}: env2: {}", path, re, L2, env2);
                env2.whenComplete((r, ex) -> logger.trace("env_lL {} {} {}: result2 {}", path, re, L2, r));
                return env2.thenCompose(e2 -> this.shadows((Env)e1._1(), (Env)e2._1(), cancel).thenApply(result -> Tuple2.of((Env)result._1(), this.context.compose(result._2(), this.context.compose(e1._2(), e2._2())))));
            });
        });
    }

    private Set.Immutable<EdgeOrData<L>> max(Set.Immutable<EdgeOrData<L>> L2) {
        Set.Transient max2 = CapsuleUtil.transientSet();
        block2: for (EdgeOrData l1 : L2) {
            for (EdgeOrData l2 : L2) {
                try {
                    if (!this.labelOrder.lt(l1, l2)) continue;
                }
                catch (Throwable t) {
                    logger.error("Unexpected exception in labelOrder", t);
                }
                continue block2;
            }
            max2.__insert((Object)l1);
        }
        return max2.freeze();
    }

    private Set.Immutable<EdgeOrData<L>> smaller(Set.Immutable<EdgeOrData<L>> L2, EdgeOrData<L> l1) {
        Set.Transient smaller = CapsuleUtil.transientSet();
        for (EdgeOrData l2 : L2) {
            if (!this.labelOrder.lt(l2, l1)) continue;
            smaller.__insert((Object)l2);
        }
        return smaller.freeze();
    }

    private IFuture<Tuple2<Env<S, L, D>, M>> env_l(ScopePath<S, L> path, LabelWf<L> re, EdgeOrData<L> l, ICancel cancel) {
        return l.match(() -> this.env_data(path, re, cancel), lbl -> this.env_edges(path, re, lbl, cancel));
    }

    private IFuture<Tuple2<Env<S, L, D>, M>> env_data(ScopePath<S, L> path, LabelWf<L> re, ICancel cancel) {
        logger.trace("env_data {} {}", path, re);
        IFuture<Optional<D>> datum = this.context.getDatum(path.getTarget());
        logger.trace("env_data {} {}: datum {}", path, re, datum);
        IFuture env = datum.thenCompose(_d -> {
            Object d = _d.orElse(null);
            if (d == null) {
                return CompletableFuture.completedFuture(Tuple2.of(Env.empty(), this.context.unitMetadata()));
            }
            return this.context.dataWf(d, cancel).thenApply(wf -> {
                if (!((Boolean)wf._1()).booleanValue()) {
                    return Tuple2.of(Env.empty(), this.context.unitMetadata());
                }
                logger.trace("env_data {} {}: datum {}", path, re, d);
                ResolutionPath resPath = path.resolve(d);
                return Tuple2.of(Env.of(resPath), wf._2());
            });
        });
        logger.trace("env_data {} {}: env {}", path, re, env);
        env.whenComplete((r, ex) -> logger.trace("env_data {} {}: result {}", path, re, env));
        return env;
    }

    private IFuture<Tuple2<Env<S, L, D>, M>> env_edges(ScopePath<S, L> path, LabelWf<L> re, L l, ICancel cancel) {
        logger.trace("env_edges {} {} {}", path, re, l);
        LabelWf<L> newRe = re.step(l).get();
        IFuture<Collection<S>> scopes = this.context.getEdges(path.getTarget(), l);
        logger.trace("env_edges {} {} {}: edge scopes {}", path, re, l, scopes);
        return scopes.thenCompose(ss -> {
            ArrayList<IFuture<Tuple2<Env<S, Object, D>, M>>> envs = new ArrayList<IFuture<Tuple2<Env<S, Object, D>, M>>>();
            for (Object nextScope : ss) {
                Optional p = path.step(l, nextScope);
                if (!p.isPresent()) continue;
                envs.add(this.context.externalEnv(p.get(), newRe, this.labelOrder, cancel));
            }
            IFuture<List<List>> listEnv = AggregateFuture.of(envs);
            logger.trace("env_edges {} {} {}: listEnv {}", path, re, l, listEnv);
            listEnv.whenComplete((r, ex) -> logger.trace("env_edges {} {} {}: listResult {}", path, re, l, listEnv));
            IFuture<Tuple2> env = listEnv.thenApply(es -> {
                Env.Builder envBuilder = Env.builder();
                M metadata = this.context.unitMetadata();
                for (Tuple2 subEnv : es) {
                    envBuilder.addAll((Iterable)subEnv._1());
                    metadata = this.context.compose(metadata, subEnv._2());
                }
                return Tuple2.of(envBuilder.build(), metadata);
            });
            logger.trace("env_edges {} {} {}: env {}", path, re, l, env);
            env.whenComplete((r, ex) -> logger.trace("env_edges {} {} {}: result {}", path, re, l, env));
            return env;
        });
    }

    private IFuture<Tuple2<Env<S, L, D>, M>> shadows(Env<S, L, D> env1, Env<S, L, D> env2, ICancel cancel) {
        Env.Builder env = Env.builder();
        Ref metadata = new Ref(this.context.unitMetadata());
        env.addAll(env1);
        return Futures.reduce(Unit.unit, env2, (u, p2) -> Futures.noneMatch(env1, p1 -> this.context.dataLeq(p2.getDatum(), p1.getDatum(), cancel).thenApply(res -> {
            metadata.set(this.context.compose(metadata.get(), res._2()));
            return (Boolean)res._1();
        })).thenApply(noneMatch -> {
            if (noneMatch.booleanValue()) {
                env.add(p2);
            }
            return Unit.unit;
        })).thenApply(u -> Tuple2.of(env.build(), metadata.get()));
    }
}

