/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.completeness;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.CompletenessUtil;
import mb.statix.spec.Spec;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.iterators.Iterables2;

public interface ICompleteness {
    public boolean isEmpty();

    public MultiSet.Immutable<EdgeOrData<ITerm>> get(ITerm var1, IUnifier var2);

    public boolean isComplete(Scope var1, EdgeOrData<ITerm> var2, IUnifier var3);

    public Set<Map.Entry<ITerm, MultiSet.Immutable<EdgeOrData<ITerm>>>> entrySet();

    default public Set.Immutable<ITermVar> vars() {
        Set.Transient _vars = CapsuleUtil.transientSet();
        this.entrySet().forEach(e -> {
            boolean bl = _vars.__insertAll(((ITerm)e.getKey()).getVars());
        });
        return _vars.freeze();
    }

    public static interface Immutable
    extends ICompleteness {
        public Immutable addAll(Immutable var1, IUnifier var2);

        public Immutable apply(ISubstitution.Immutable var1);

        public Immutable apply(IRenaming var1);

        public Immutable removeAll(Collection<? extends ITerm> var1, IUnifier var2);

        public Immutable retainAll(Collection<? extends ITerm> var1, IUnifier var2);

        public Immutable updateAll(Iterable<? extends ITermVar> var1, IUnifier var2);

        public Transient melt();
    }

    public static interface Transient
    extends ICompleteness {
        public void add(ITerm var1, EdgeOrData<ITerm> var2, IUnifier var3);

        default public void add(IConstraint constraint, Spec spec, IUnifier unifier) {
            CompletenessUtil.criticalEdges(constraint, spec, (scopeTerm, label) -> this.add((ITerm)scopeTerm, (EdgeOrData<ITerm>)label, unifier));
        }

        default public void addAll(Collection<? extends IConstraint> constraints, Spec spec, IUnifier unifier) {
            constraints.forEach(c -> this.add((IConstraint)c, spec, unifier));
        }

        public void addAll(Immutable var1, IUnifier var2);

        public Set.Immutable<CriticalEdge> remove(ITerm var1, EdgeOrData<ITerm> var2, IUnifier var3);

        default public Set.Immutable<CriticalEdge> remove(IConstraint constraint, Spec spec, IUnifier unifier) {
            Set.Transient removedEdges = CapsuleUtil.transientSet();
            CompletenessUtil.criticalEdges(constraint, spec, (scopeTerm, label) -> removedEdges.__insertAll(this.remove((ITerm)scopeTerm, (EdgeOrData<ITerm>)label, unifier)));
            return removedEdges.freeze();
        }

        default public Set.Immutable<CriticalEdge> removeAll(Iterable<? extends IConstraint> constraints, Spec spec, IUnifier unifier) {
            return (Set.Immutable)Iterables2.stream(constraints).flatMap(c -> this.remove((IConstraint)c, spec, unifier).stream()).collect(CapsuleCollectors.toSet());
        }

        public Set.Immutable<CriticalEdge> removeAll(Immutable var1, IUnifier var2);

        public void update(ITermVar var1, IUnifier var2);

        default public void updateAll(Iterable<? extends ITermVar> vars, IUnifier unifier) {
            Iterables2.stream(vars).forEach(c -> this.update((ITermVar)c, unifier));
        }

        public void apply(ISubstitution.Immutable var1);

        public void apply(IRenaming var1);

        public Immutable freeze();
    }
}

