/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.unification.ud.PersistentUniDisunifier;
import mb.statix.constraints.Constraints;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.MessageKind;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.completeness.Completeness;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.solver.persistent.State;
import mb.statix.solver.tracer.EmptyTracer;
import mb.statix.solver.tracer.SolverTracer;
import mb.statix.spec.Spec;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Function2;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class ASolverResult<TR extends SolverTracer.IResult<TR>> {
    @Value.Parameter
    public abstract Spec spec();

    @Value.Parameter
    public abstract IState.Immutable state();

    @Nullable
    @Value.Parameter
    public abstract TR traceResult();

    @Value.Parameter
    public abstract Map.Immutable<IConstraint, IMessage> messages();

    @Value.Parameter
    public abstract Map.Immutable<IConstraint, Delay> delays();

    @Value.Parameter
    public abstract Map.Immutable<ITermVar, ITermVar> existentials();

    @Value.Parameter
    public abstract Set.Immutable<ITermVar> updatedVars();

    @Value.Parameter
    public abstract Set.Immutable<CriticalEdge> removedEdges();

    @Value.Parameter
    public abstract ICompleteness.Immutable completeness();

    @Value.Default
    public int totalSolved() {
        return 0;
    }

    @Value.Default
    public int totalCriticalEdges() {
        return 0;
    }

    public boolean hasErrors() {
        return this.messages().values().stream().anyMatch(m -> m.kind().equals(MessageKind.ERROR));
    }

    public Delay delay() {
        return Delay.of(this.delays().values());
    }

    public IConstraint delayed() {
        return Constraints.conjoin(this.delays().keySet());
    }

    public static SolverResult<EmptyTracer.Empty> of(Spec spec) {
        return SolverResult.of(spec, State.of(), EmptyTracer.Empty.of(), CapsuleUtil.immutableMap(), CapsuleUtil.immutableMap(), CapsuleUtil.immutableMap(), CapsuleUtil.immutableSet(), CapsuleUtil.immutableSet(), Completeness.Immutable.of());
    }

    public static <R extends SolverTracer.IResult<R>> SolverResult<R> of(Spec spec, @Nullable R tracerResult) {
        return SolverResult.of(spec, State.of(), tracerResult, CapsuleUtil.immutableMap(), CapsuleUtil.immutableMap(), CapsuleUtil.immutableMap(), CapsuleUtil.immutableSet(), CapsuleUtil.immutableSet(), Completeness.Immutable.of());
    }

    public SolverResult<TR> combine(SolverResult<TR> other) {
        SolverResult.Builder<TR> combined = SolverResult.builder().from(this);
        combined.state(this.state().add(other.state()));
        combined.messages(ASolverResult.merge(this.messages(), other.messages()));
        combined.delays(ASolverResult.merge(this.delays(), other.delays(), (d1, d2) -> Delay.of(Arrays.asList(d1, d2))));
        combined.existentials((Map.Immutable<ITermVar, ITermVar>)this.existentials().__putAll(other.existentials()));
        combined.updatedVars((Set.Immutable<ITermVar>)this.updatedVars().__insertAll(other.updatedVars()));
        combined.removedEdges((Set.Immutable<CriticalEdge>)this.removedEdges().__insertAll(other.removedEdges()));
        combined.completeness(this.completeness().addAll(other.completeness(), PersistentUniDisunifier.Immutable.of()));
        combined.totalSolved(this.totalSolved() + other.totalSolved());
        combined.totalCriticalEdges(this.totalCriticalEdges() + other.totalCriticalEdges());
        combined.traceResult(this.traceResult().combine(other.traceResult()));
        return combined.build();
    }

    private static <K, V> Map.Immutable<K, V> merge(Map.Immutable<K, V> map1, Map.Immutable<K, V> map2) {
        Map.Transient builder = CapsuleUtil.transientMap();
        builder.__putAll(map1);
        map2.forEach((k, v) -> {
            if (!map1.containsKey(k)) {
                builder.__put(k, v);
            }
        });
        return builder.freeze();
    }

    private static <K, V> Map.Immutable<K, V> merge(Map.Immutable<K, V> map1, Map.Immutable<K, V> map2, Function2<V, V, V> resolveConflict) {
        Map.Transient builder = CapsuleUtil.transientMap();
        builder.__putAll(map1);
        map2.forEach((k, v) -> {
            if (!map1.containsKey(k)) {
                builder.__put(k, v);
            } else {
                builder.__put(k, resolveConflict.apply(map1.get(k), v));
            }
        });
        return builder.freeze();
    }
}

