/*
 * Decompiled with CFR 0.152.
 */
package mb.util.vfs2.resource;

import java.util.Arrays;

public final class AntPattern {
    private final String[] tokenizedPattern;
    private final boolean isCaseSensitive;
    private static final String DEEP_TREE_MATCH = "**";

    public AntPattern(String pattern) {
        this(pattern, true);
    }

    public AntPattern(String pattern, boolean isCaseSensitive) {
        if (pattern.endsWith("/")) {
            pattern = String.valueOf(pattern) + DEEP_TREE_MATCH;
        }
        this.tokenizedPattern = AntPattern.tokenizePathAsArray(pattern);
        this.isCaseSensitive = isCaseSensitive;
    }

    public boolean match(String path) {
        return AntPattern.matchPath(this.tokenizedPattern, AntPattern.tokenizePathAsArray(path), this.isCaseSensitive);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean matchPath(String[] tokenizedPattern, String[] strDirs, boolean isCaseSensitive) {
        patIdxStart = 0;
        patIdxEnd = tokenizedPattern.length - 1;
        strIdxStart = 0;
        strIdxEnd = strDirs.length - 1;
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd) {
            patDir = tokenizedPattern[patIdxStart];
            if (patDir.equals("**")) break;
            if (!AntPattern.match(patDir, strDirs[strIdxStart], isCaseSensitive)) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            i = patIdxStart;
            while (i <= patIdxEnd) {
                if (!tokenizedPattern[i].equals("**")) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxStart <= patIdxEnd) ** GOTO lbl28
        return false;
        while (!(patDir = tokenizedPattern[patIdxEnd]).equals("**")) {
            if (!AntPattern.match(patDir, strDirs[strIdxEnd], isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
lbl28:
            // 2 sources

            if (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd) continue;
        }
        if (strIdxStart <= strIdxEnd) ** GOTO lbl70
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (!tokenizedPattern[i].equals("**")) {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (tokenizedPattern[i].equals("**")) {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block19: {
                    j = 0;
                    while (j < patLength) {
                        subPat = tokenizedPattern[patIdxStart + j + 1];
                        subStr = strDirs[strIdxStart + i + j];
                        if (AntPattern.match(subPat, subStr, isCaseSensitive)) {
                            ++j;
                            continue;
                        }
                        break block19;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl70:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl71:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (!tokenizedPattern[i].equals("**")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean match(String pattern, String str, boolean caseSensitive) {
        patArr = pattern.toCharArray();
        strArr = str.toCharArray();
        patIdxStart = 0;
        patIdxEnd = patArr.length - 1;
        strIdxStart = 0;
        strIdxEnd = strArr.length - 1;
        containsStar = false;
        i = 0;
        while (i < patArr.length) {
            if (patArr[i] == '*') {
                containsStar = true;
                break;
            }
            ++i;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            i = 0;
            while (i <= patIdxEnd) {
                ch = patArr[i];
                if (ch != '?' && AntPattern.different(caseSensitive, ch, strArr[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && AntPattern.different(caseSensitive, ch, strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            return AntPattern.allStars(patArr, patIdxStart, patIdxEnd);
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && AntPattern.different(caseSensitive, ch, strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart <= strIdxEnd) ** GOTO lbl76
        return AntPattern.allStars(patArr, patIdxStart, patIdxEnd);
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patArr[i] == '*') {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block20: {
                    j = 0;
                    while (j < patLength) {
                        ch = patArr[patIdxStart + j + 1];
                        if (ch == '?' || !AntPattern.different(caseSensitive, ch, strArr[strIdxStart + i + j])) {
                            ++j;
                            continue;
                        }
                        break block20;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl76:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl77:
        // 1 sources

        return AntPattern.allStars(patArr, patIdxStart, patIdxEnd);
    }

    private static boolean allStars(char[] chars, int start, int end) {
        int i = start;
        while (i <= end) {
            if (chars[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean different(boolean caseSensitive, char ch, char other) {
        return caseSensitive ? ch != other : Character.toUpperCase(ch) != Character.toUpperCase(other);
    }

    private static String[] tokenizePathAsArray(String path) {
        String root = null;
        if (AntPattern.isAbsolutePath(path)) {
            String[] s = AntPattern.dissect(path);
            root = s[0];
            path = s[1];
        }
        char sep = '/';
        int start = 0;
        int len = path.length();
        int count = 0;
        int pos = 0;
        while (pos < len) {
            if (path.charAt(pos) == sep) {
                if (pos != start) {
                    ++count;
                }
                start = pos + 1;
            }
            ++pos;
        }
        if (len != start) {
            ++count;
        }
        String[] l = new String[count + (root == null ? 0 : 1)];
        if (root != null) {
            l[0] = root;
            count = 1;
        } else {
            count = 0;
        }
        start = 0;
        int pos2 = 0;
        while (pos2 < len) {
            if (path.charAt(pos2) == sep) {
                if (pos2 != start) {
                    String tok = path.substring(start, pos2);
                    l[count++] = tok;
                }
                start = pos2 + 1;
            }
            ++pos2;
        }
        if (len != start) {
            String tok;
            l[count] = tok = path.substring(start);
        }
        return l;
    }

    public static boolean isAbsolutePath(String filename) {
        int len = filename.length();
        if (len == 0) {
            return false;
        }
        char sep = '/';
        char c = filename.charAt(0);
        return c == sep;
    }

    public static String[] dissect(String path) {
        if (!AntPattern.isAbsolutePath(path)) {
            throw new RuntimeException(String.valueOf(path) + " is not an absolute path");
        }
        String root = null;
        root = "/";
        path = path.substring(1);
        return new String[]{root, path};
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isCaseSensitive ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.tokenizedPattern);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AntPattern other = (AntPattern)obj;
        if (this.isCaseSensitive != other.isCaseSensitive) {
            return false;
        }
        return Arrays.equals(this.tokenizedPattern, other.tokenizedPattern);
    }

    public String toString() {
        return Arrays.toString(this.tokenizedPattern);
    }
}

