/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.config;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.metaborg.core.config.AConfig;
import org.metaborg.core.config.GenerateConfig;
import org.metaborg.core.config.IConfig;
import org.metaborg.core.config.IExportConfig;
import org.metaborg.core.config.IGenerateConfig;
import org.metaborg.core.config.ILanguageComponentConfig;
import org.metaborg.core.config.ISourceConfig;
import org.metaborg.core.config.JSGLR2Logging;
import org.metaborg.core.config.JSGLRVersion;
import org.metaborg.core.config.LangDirExport;
import org.metaborg.core.config.LangFileExport;
import org.metaborg.core.config.ProjectConfig;
import org.metaborg.core.config.ResourceExport;
import org.metaborg.core.config.Sdf2tableVersion;
import org.metaborg.core.config.StatixSolverMode;
import org.metaborg.core.language.LanguageContributionIdentifier;
import org.metaborg.core.language.LanguageIdentifier;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageBuilder;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class LanguageComponentConfig
extends AConfig
implements ILanguageComponentConfig,
IConfig {
    private static final String PROP_IDENTIFIER = "id";
    private static final String PROP_NAME = "name";
    private static final String PROP_LANGUAGE_CONTRIBUTIONS = "contributions";
    private static final String PROP_GENERATES = "generates";
    private static final String PROP_EXPORTS = "exports";
    private static final String PROP_LANGUAGE = "language";
    private static final String PROP_SDF = "language.sdf";
    private static final String PROP_SDF_ENABLED = "language.sdf.enabled";
    private static final String PROP_SDF_PARSE_TABLE = "language.sdf.parse-table";
    private static final String PROP_SDF_COMPLETION_PARSE_TABLE = "language.sdf.completion-parse-table";
    private static final String PROP_SDF2TABLE_VERSION = "language.sdf.sdf2table";
    private static final String PROP_SDF2TABLE_CHECKOVERLAP = "language.sdf.check-overlap";
    private static final String PROP_SDF2TABLE_CHECKPRIORITIES = "language.sdf.check-priorities";
    private static final String PROP_SDF_JSGLR_VERSION = "language.sdf.jsglr-version";
    private static final String PROP_SDF_JSGLR2_LOGGING = "language.sdf.jsglr2-logging";
    private static final String PROP_STATIX = "language.statix";
    private static final String PROP_STATIX_CONCURRENT = "language.statix.concurrent";
    private static final String PROP_STATIX_MODE = "language.statix.mode";
    private static final String PROP_STR = "language.stratego";
    private static final String PROP_STR_ENABLED = "language.stratego.enabled";
    private final ProjectConfig projectConfig;
    private static final ILogger logger = LoggerUtils.logger(LanguageComponentConfig.class);

    public LanguageComponentConfig(HierarchicalConfiguration<ImmutableNode> config, ProjectConfig projectConfig) {
        super(config);
        this.projectConfig = projectConfig;
    }

    protected LanguageComponentConfig(HierarchicalConfiguration<ImmutableNode> config, ProjectConfig projectConfig, @Nullable LanguageIdentifier identifier, @Nullable String name, @Nullable Boolean sdfEnabled, @Nullable String parseTable, @Nullable String completionParseTable, @Nullable Sdf2tableVersion sdf2tableVersion, @Nullable Boolean checkOverlap, @Nullable Boolean checkPriorities, @Nullable Boolean dataDependent, @Nullable JSGLRVersion jsglrVersion, @Nullable JSGLR2Logging jsglr2Logging, @Nullable StatixSolverMode statixMode, @Nullable Boolean strEnabled, @Nullable Collection<LanguageContributionIdentifier> langContribs, @Nullable Collection<IGenerateConfig> generates, @Nullable Collection<IExportConfig> exports) {
        super(config);
        this.projectConfig = projectConfig;
        if (sdfEnabled != null) {
            config.setProperty(PROP_SDF_ENABLED, (Object)sdfEnabled);
        }
        if (sdf2tableVersion != null) {
            config.setProperty(PROP_SDF2TABLE_VERSION, (Object)sdf2tableVersion);
        }
        if (parseTable != null) {
            config.setProperty(PROP_SDF_PARSE_TABLE, (Object)parseTable);
        }
        if (checkOverlap != null) {
            config.setProperty(PROP_SDF2TABLE_CHECKOVERLAP, (Object)checkOverlap);
        }
        if (checkPriorities != null) {
            config.setProperty(PROP_SDF2TABLE_CHECKPRIORITIES, (Object)checkPriorities);
        }
        if (completionParseTable != null) {
            config.setProperty(PROP_SDF_COMPLETION_PARSE_TABLE, (Object)completionParseTable);
        }
        if (jsglrVersion != null) {
            config.setProperty(PROP_SDF_JSGLR_VERSION, (Object)jsglrVersion);
        }
        if (jsglr2Logging != null) {
            config.setProperty(PROP_SDF_JSGLR2_LOGGING, (Object)jsglr2Logging);
        }
        if (statixMode != null) {
            config.setProperty(PROP_STATIX_MODE, (Object)statixMode);
        }
        if (strEnabled != null) {
            config.setProperty(PROP_STR_ENABLED, (Object)strEnabled);
        }
        if (name != null) {
            config.setProperty(PROP_NAME, (Object)name);
        }
        if (identifier != null) {
            config.setProperty(PROP_IDENTIFIER, (Object)identifier);
        }
        if (langContribs != null) {
            config.setProperty(PROP_LANGUAGE_CONTRIBUTIONS, langContribs);
        }
        if (generates != null) {
            config.setProperty(PROP_GENERATES, generates);
        }
        if (exports != null) {
            config.setProperty(PROP_EXPORTS, exports);
        }
    }

    @Override
    public HierarchicalConfiguration<ImmutableNode> getConfig() {
        return this.projectConfig.getConfig();
    }

    @Override
    public String metaborgVersion() {
        return this.projectConfig.metaborgVersion();
    }

    @Override
    public Collection<ISourceConfig> sources() {
        return this.projectConfig.sources();
    }

    @Override
    public Collection<LanguageIdentifier> compileDeps() {
        return this.projectConfig.compileDeps();
    }

    @Override
    public Collection<LanguageIdentifier> sourceDeps() {
        return this.projectConfig.sourceDeps();
    }

    @Override
    public Collection<LanguageIdentifier> javaDeps() {
        return this.projectConfig.javaDeps();
    }

    @Override
    public LanguageIdentifier identifier() {
        return (LanguageIdentifier)this.config.get(LanguageIdentifier.class, PROP_IDENTIFIER);
    }

    @Override
    public String name() {
        return this.config.getString(PROP_NAME);
    }

    @Override
    public Collection<LanguageContributionIdentifier> langContribs() {
        List langContribConfigs = this.config.configurationsAt(PROP_LANGUAGE_CONTRIBUTIONS);
        ArrayList<LanguageContributionIdentifier> langContribs = new ArrayList<LanguageContributionIdentifier>(langContribConfigs.size());
        for (HierarchicalConfiguration langContribConfig : langContribConfigs) {
            String idString = langContribConfig.getString(PROP_IDENTIFIER);
            LanguageIdentifier id = LanguageIdentifier.parse(idString);
            String name = langContribConfig.getString(PROP_NAME);
            langContribs.add(new LanguageContributionIdentifier(id, name));
        }
        return langContribs;
    }

    @Override
    public Collection<IGenerateConfig> generates() {
        List generateConfigs = this.config.configurationsAt(PROP_GENERATES);
        ArrayList<IGenerateConfig> generates = new ArrayList<IGenerateConfig>(generateConfigs.size());
        for (HierarchicalConfiguration generateConfig : generateConfigs) {
            List languages = generateConfig.getList(String.class, PROP_LANGUAGE, Collections.emptyList());
            String directory = generateConfig.getString("directory");
            if (directory == null) continue;
            for (String language : languages) {
                generates.add(new GenerateConfig(language, directory));
            }
        }
        return generates;
    }

    @Override
    public Collection<IExportConfig> exports() {
        List exportConfigs = this.config.configurationsAt(PROP_EXPORTS, false);
        ArrayList<IExportConfig> exports = new ArrayList<IExportConfig>(exportConfigs.size());
        for (HierarchicalConfiguration exportConfig : exportConfigs) {
            List languages = exportConfig.getList(String.class, PROP_LANGUAGE);
            String directory = exportConfig.getString("directory");
            String file = exportConfig.getString("file");
            List includes = exportConfig.getList(String.class, "includes", new ArrayList());
            List excludes = exportConfig.getList(String.class, "excludes", new ArrayList());
            if (languages != null) {
                if (directory != null) {
                    for (String language : languages) {
                        exports.add(new LangDirExport(language, directory, includes, excludes));
                    }
                    continue;
                }
                if (file == null) continue;
                for (String language : languages) {
                    exports.add(new LangFileExport(language, file));
                }
                continue;
            }
            if (directory == null) continue;
            exports.add(new ResourceExport(directory, includes, excludes));
        }
        return exports;
    }

    public Collection<IMessage> validate(MessageBuilder mb) {
        Collection<IMessage> messages = this.projectConfig.validate(mb);
        String idStr = this.config.getString(PROP_IDENTIFIER);
        if (idStr == null) {
            messages.add(mb.withMessage("Field 'id' must be set").build());
        } else {
            try {
                LanguageIdentifier.parseFull(idStr);
            }
            catch (IllegalArgumentException e) {
                messages.add(mb.withMessage("Invalid identifier in 'id' field. " + e.getMessage()).build());
            }
        }
        String name = this.config.getString(PROP_NAME);
        if (name == null) {
            messages.add(mb.withMessage("Field 'name' must be set").build());
        } else if (!LanguageIdentifier.validId(name)) {
            messages.add(mb.withMessage("Field 'name' contains invalid characters, may only consist of alphanumeral and _ - . characters").build());
        }
        return messages;
    }

    @Override
    public Boolean sdfEnabled() {
        return this.config.getBoolean(PROP_SDF_ENABLED, true);
    }

    @Override
    public String parseTable() {
        String value = this.config.getString(PROP_SDF_PARSE_TABLE);
        return value != null ? value : "target/metaborg/sdf.tbl";
    }

    @Override
    public Boolean checkPriorities() {
        return this.config.getBoolean(PROP_SDF2TABLE_CHECKPRIORITIES, false);
    }

    @Override
    public Boolean checkOverlap() {
        return this.config.getBoolean(PROP_SDF2TABLE_CHECKOVERLAP, false);
    }

    @Override
    public String completionsParseTable() {
        String value = this.config.getString(PROP_SDF_COMPLETION_PARSE_TABLE);
        return value != null ? value : "target/metaborg/sdf-completions.tbl";
    }

    @Override
    public Sdf2tableVersion sdf2tableVersion() {
        String value = this.config.getString(PROP_SDF2TABLE_VERSION);
        if (value != null) {
            return Sdf2tableVersion.valueOf(value);
        }
        if (this.sdfEnabled().booleanValue()) {
            logger.warn("No {} config found for {}; defaulting to java", PROP_SDF2TABLE_VERSION, this.identifier().toString());
        }
        return Sdf2tableVersion.java;
    }

    @Override
    public JSGLRVersion jsglrVersion() {
        String value = this.config.getString(PROP_SDF_JSGLR_VERSION);
        if (value != null && value.equals("data-dependent")) {
            return JSGLRVersion.dataDependent;
        }
        if (value != null && value.equals("layout-sensitive")) {
            return JSGLRVersion.layoutSensitive;
        }
        if (value != null && value.equals("recovery-incremental")) {
            return JSGLRVersion.recoveryIncremental;
        }
        return value != null ? JSGLRVersion.valueOf(value) : JSGLRVersion.v1;
    }

    @Override
    public JSGLR2Logging jsglr2Logging() {
        String value = this.config.getString(PROP_SDF_JSGLR2_LOGGING);
        return value != null ? JSGLR2Logging.valueOf(value) : JSGLR2Logging.none;
    }

    @Override
    public StatixSolverMode statixSolverMode() {
        String value = this.config.getString(PROP_STATIX_MODE);
        if (value == null) {
            if (this.config.getBoolean(PROP_STATIX_CONCURRENT, false)) {
                logger.warn("Config option {} is deprecated. Use {}: concurrent instead.", PROP_STATIX_CONCURRENT, PROP_STATIX_MODE);
                return StatixSolverMode.concurrent;
            }
            return StatixSolverMode.traditional;
        }
        return StatixSolverMode.valueOf(value);
    }

    @Override
    public Boolean strEnabled() {
        return this.config.getBoolean(PROP_STR_ENABLED, true);
    }
}

