/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.language;

import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.metaborg.util.Strings;
import org.metaborg.util.order.ChainedComparison;

public class LanguageVersion
implements Comparable<LanguageVersion>,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final String SNAPSHOT = "snapshot";
    @Nullable
    private final Integer major;
    @Nullable
    private final Integer minor;
    @Nullable
    private final Integer incremental;
    @Nullable
    private final String qualifier;

    public LanguageVersion(int major) {
        this(major, null, null, null);
    }

    public LanguageVersion(int major, int minor) {
        this(major, minor, null, null);
    }

    public LanguageVersion(int major, int minor, int incremental) {
        this(major, minor, incremental, null);
    }

    public LanguageVersion(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer incremental, @Nullable String qualifier) {
        this.major = major;
        this.minor = minor;
        this.incremental = incremental;
        this.qualifier = qualifier;
    }

    public static LanguageVersion parse(String version) {
        String numericalPart;
        Integer major = null;
        Integer minor = null;
        Integer incremental = null;
        String qualifier = null;
        int hyphenIndex = version.indexOf(45);
        if (hyphenIndex < 0) {
            numericalPart = version;
        } else {
            numericalPart = version.substring(0, hyphenIndex);
            qualifier = version.substring(hyphenIndex);
        }
        if (!numericalPart.contains(".") && !numericalPart.startsWith("0")) {
            try {
                major = Integer.valueOf(numericalPart);
            }
            catch (NumberFormatException e) {
                qualifier = version;
            }
        } else {
            boolean fallback = false;
            StringTokenizer tok = new StringTokenizer(numericalPart, ".");
            try {
                major = LanguageVersion.getNextIntegerToken(tok);
                if (tok.hasMoreTokens()) {
                    minor = LanguageVersion.getNextIntegerToken(tok);
                }
                if (tok.hasMoreTokens()) {
                    incremental = LanguageVersion.getNextIntegerToken(tok);
                }
                if (tok.hasMoreTokens()) {
                    qualifier = tok.nextToken();
                    fallback = Pattern.compile("\\d+").matcher(qualifier).matches();
                }
                if (numericalPart.contains("..") || numericalPart.startsWith(".") || numericalPart.endsWith(".")) {
                    fallback = true;
                }
            }
            catch (NumberFormatException e) {
                fallback = true;
            }
            if (fallback) {
                qualifier = version;
                major = null;
                minor = null;
                incremental = null;
            }
        }
        return new LanguageVersion(major, minor, incremental, qualifier);
    }

    private static Integer getNextIntegerToken(StringTokenizer tok) {
        try {
            String s = tok.nextToken();
            if (s.length() > 1 && s.startsWith("0")) {
                throw new NumberFormatException("Number part has a leading 0: '" + s + "'");
            }
            return Integer.valueOf(s);
        }
        catch (NoSuchElementException e) {
            throw new NumberFormatException("Number is invalid");
        }
    }

    @Deprecated
    public static boolean valid(String version) {
        return true;
    }

    @Override
    public int compareTo(LanguageVersion other) {
        return new ChainedComparison().compare(this.major, other.major, Comparator.nullsFirst(Comparator.naturalOrder())).compare(this.minor, other.minor, Comparator.nullsFirst(Comparator.naturalOrder())).compare(this.incremental, other.incremental, Comparator.nullsFirst(Comparator.naturalOrder())).compare(this.qualifier, other.qualifier, (left, right) -> {
            boolean rightSnapshot;
            boolean leftNull = Strings.isNullOrEmpty(left);
            boolean rightNull = Strings.isNullOrEmpty(right);
            if (leftNull && rightNull) {
                return 0;
            }
            boolean leftSnapshot = !leftNull && left.toLowerCase().contains(SNAPSHOT);
            boolean bl = rightSnapshot = !rightNull && right.toLowerCase().contains(SNAPSHOT);
            if (leftSnapshot && rightSnapshot) {
                return 0;
            }
            if (leftNull) {
                return rightSnapshot ? -1 : 1;
            }
            if (rightNull) {
                return leftSnapshot ? 1 : -1;
            }
            if (leftSnapshot) {
                return 1;
            }
            if (rightSnapshot) {
                return -1;
            }
            return left.compareTo((String)right);
        }).result();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LanguageVersion other = (LanguageVersion)o;
        if (this.major != null ? !this.major.equals(other.major) : other.major != null) {
            return false;
        }
        if (this.minor != null ? !this.minor.equals(other.minor) : other.minor != null) {
            return false;
        }
        if (this.incremental != null ? !this.incremental.equals(other.incremental) : other.incremental != null) {
            return false;
        }
        return Strings.nullToEmpty(this.qualifier).equalsIgnoreCase(Strings.nullToEmpty(other.qualifier));
    }

    public int hashCode() {
        int result = this.major != null ? this.major.hashCode() : 0;
        result = 31 * result + (this.minor != null ? this.minor.hashCode() : 0);
        result = 31 * result + (this.incremental != null ? this.incremental.hashCode() : 0);
        result = 31 * result + (this.qualifier != null ? this.qualifier.toLowerCase().hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.major != null) {
            sb.append(this.major);
        } else if (this.minor != null || this.incremental != null) {
            sb.append(0);
        }
        if (this.minor != null) {
            sb.append('.');
            sb.append(this.minor);
        } else if (this.incremental != null) {
            sb.append(0);
        }
        if (this.incremental != null) {
            sb.append('.');
            sb.append(this.incremental);
        }
        if (this.qualifier != null) {
            sb.append(this.qualifier);
        }
        return sb.toString();
    }
}

