/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.project;

import jakarta.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.config.ConfigRequest;
import org.metaborg.core.config.IProjectConfig;
import org.metaborg.core.config.IProjectConfigService;
import org.metaborg.core.messages.StreamMessagePrinter;
import org.metaborg.core.project.IProject;
import org.metaborg.core.project.IProjectService;
import org.metaborg.core.project.Project;
import org.metaborg.core.source.ISourceTextService;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class ConfigBasedProjectService
implements IProjectService {
    private static final ILogger logger = LoggerUtils.logger(ConfigBasedProjectService.class);
    private final ConcurrentMap<FileName, IProject> projects = new ConcurrentHashMap<FileName, IProject>();
    private final ISourceTextService sourceTextService;
    private final IProjectConfigService projectConfigService;

    @Inject
    public ConfigBasedProjectService(ISourceTextService sourceTextService, IProjectConfigService projectConfigService) {
        this.sourceTextService = sourceTextService;
        this.projectConfigService = projectConfigService;
    }

    @Override
    public IProject get(FileObject resource) {
        IProject project = this.getProject(resource);
        if (project == null) {
            project = this.findProject(resource);
        }
        return project;
    }

    private IProject getProject(FileObject resource) {
        for (Map.Entry entry : this.projects.entrySet()) {
            if (!resource.getName().isAncestor((FileName)entry.getKey())) continue;
            return (IProject)entry.getValue();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IProject findProject(FileObject resource) {
        try {
            FileObject dir;
            FileObject fileObject = dir = resource.isFolder() ? resource : resource.getParent();
            while (dir != null) {
                FileName name = dir.getName();
                if (this.projectConfigService.available(dir)) {
                    IProjectConfig config;
                    ConfigRequest<? extends IProjectConfig> configRequest = this.projectConfigService.get(dir);
                    if (!configRequest.valid()) {
                        logger.error("Errors occurred when retrieving project configuration from project directory {}", dir);
                        configRequest.reportErrors(new StreamMessagePrinter(this.sourceTextService, false, false, logger));
                    }
                    if ((config = configRequest.config()) == null) {
                        logger.error("Could not retrieve project configuration from project directory {}", dir);
                        return null;
                    }
                    Project project = new Project(dir, config);
                    IProject prevProject = this.projects.putIfAbsent(name, project);
                    if (prevProject != null) {
                        logger.warn("Project with location {} already exists", name);
                        return prevProject;
                    }
                    return project;
                }
                dir = dir.getParent();
            }
        }
        catch (FileSystemException e) {
            logger.error("Error while searching for project configuration.", e);
        }
        logger.warn("No project configuration file was found for {}.", resource);
        return null;
    }
}

