/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.language;

import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.config.ConfigRequest;
import org.metaborg.core.config.ILanguageComponentConfig;
import org.metaborg.core.config.ILanguageComponentConfigService;
import org.metaborg.core.context.IContextFactory;
import org.metaborg.core.context.IContextStrategy;
import org.metaborg.core.language.ComponentCreationConfig;
import org.metaborg.core.language.IComponentCreationConfigRequest;
import org.metaborg.core.language.ILanguageComponentFactory;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.core.resource.ResourceUtils;
import org.metaborg.spoofax.core.analysis.ISpoofaxAnalyzer;
import org.metaborg.spoofax.core.dynamicclassloading.DynamicClassLoadingFacet;
import org.metaborg.spoofax.core.dynamicclassloading.DynamicClassLoadingFacetFromESV;
import org.metaborg.spoofax.core.esv.ESVReader;
import org.metaborg.spoofax.core.language.ComponentFactoryRequest;
import org.metaborg.spoofax.core.language.LanguageFileScanSelector;
import org.metaborg.spoofax.core.stratego.StrategoRuntimeFacet;
import org.metaborg.spoofax.core.stratego.StrategoRuntimeFacetFromESV;
import org.metaborg.spoofax.core.syntax.SyntaxFacet;
import org.metaborg.spoofax.core.syntax.SyntaxFacetFromESV;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.io.binary.TermReader;
import org.spoofax.terms.util.TermUtils;

public class LanguageComponentFactory
implements ILanguageComponentFactory {
    private static final ILogger logger = LoggerUtils.logger(LanguageComponentFactory.class);
    private final IResourceService resourceService;
    private final ILanguageComponentConfigService componentConfigService;
    private final ITermFactory termFactory;
    private final Map<String, IContextFactory> contextFactories;
    private final Map<String, IContextStrategy> contextStrategies;
    private final Map<String, ISpoofaxAnalyzer> analyzers;

    @Inject
    public LanguageComponentFactory(IResourceService resourceService, ILanguageComponentConfigService componentConfigService, ITermFactory termFactory, Map<String, IContextFactory> contextFactories, Map<String, IContextStrategy> contextStrategies, Map<String, ISpoofaxAnalyzer> analyzers) {
        this.resourceService = resourceService;
        this.componentConfigService = componentConfigService;
        this.termFactory = termFactory;
        this.contextFactories = contextFactories;
        this.contextStrategies = contextStrategies;
        this.analyzers = analyzers;
    }

    @Override
    public IComponentCreationConfigRequest requestFromDirectory(FileObject directory) throws MetaborgException {
        try {
            if (!directory.exists()) {
                throw new MetaborgException(logger.format("Cannot request component creation from directory {}, it does not exist", directory));
            }
            if (!directory.isFolder()) {
                throw new MetaborgException(logger.format("Cannot request component creation from {}, it is not a directory", directory));
            }
            if (!this.componentConfigService.available(directory)) {
                throw new MetaborgException(logger.format("Cannot request component creation from directory {}, there is no component config file inside the directory", directory));
            }
            return this.request(directory);
        }
        catch (IOException e) {
            throw new MetaborgException(logger.format("Cannot request component creation from directory {}, unexpected I/O error", directory), e);
        }
    }

    @Override
    public IComponentCreationConfigRequest requestFromArchive(FileObject archiveFile) throws MetaborgException {
        try {
            if (!archiveFile.exists()) {
                throw new MetaborgException(logger.format("Cannot request component creation from archive file {}, it does not exist", archiveFile));
            }
            if (!archiveFile.isFile()) {
                throw new MetaborgException(logger.format("Cannot request component creation from archive file {}, it is not a file", archiveFile));
            }
            String archiveFileUri = archiveFile.getName().getURI();
            FileObject archiveContents = this.resourceService.resolve("zip:" + archiveFileUri + "!/");
            if (!archiveContents.exists() || !archiveContents.isFolder()) {
                throw new MetaborgException(logger.format("Cannot request component creation from archive file {}, it is not a zip archive", archiveFile));
            }
            if (!this.componentConfigService.available(archiveContents)) {
                throw new MetaborgException(logger.format("Cannot request component creation from archive file {}, there is no component config file inside the archive", archiveFile));
            }
            return this.request(archiveContents);
        }
        catch (IOException e) {
            throw new MetaborgException(logger.format("Cannot request component creation from archive file {}, unexpected I/O error", archiveFile), e);
        }
    }

    @Override
    public Collection<IComponentCreationConfigRequest> requestAllInDirectory(FileObject directory) throws MetaborgException {
        HashSet<IComponentCreationConfigRequest> requests = new HashSet<IComponentCreationConfigRequest>();
        try {
            if (!directory.exists()) {
                throw new MetaborgException("Cannot scan directory " + directory + ", it does not exist");
            }
            if (!directory.isFolder()) {
                throw new MetaborgException("Cannot scan " + directory + ", it is not a directory");
            }
            Iterable<FileObject> files = ResourceUtils.find(directory, new LanguageFileScanSelector());
            for (FileObject file : files) {
                IComponentCreationConfigRequest request = file.isFolder() ? this.requestFromDirectory(file) : this.requestFromArchive(file);
                requests.add(request);
            }
        }
        catch (FileSystemException e) {
            throw new MetaborgException("Cannot scan " + directory + ", unexpected I/O error", e);
        }
        return requests;
    }

    private IComponentCreationConfigRequest request(FileObject root) throws MetaborgException {
        IStrategoAppl esvTerm;
        ILanguageComponentConfig config;
        LinkedList<String> errors = new LinkedList<String>();
        LinkedList<Throwable> exceptions = new LinkedList<Throwable>();
        ConfigRequest<ILanguageComponentConfig> configRequest = this.componentConfigService.get(root);
        if (!configRequest.valid()) {
            for (IMessage message : configRequest.errors()) {
                errors.add(message.message());
                Throwable exception = message.exception();
                if (exception == null) continue;
                exceptions.add(exception);
            }
        }
        if ((config = configRequest.config()) == null) {
            String message = logger.format("Cannot retrieve language component configuration at {}", root);
            errors.add(message);
            return new ComponentFactoryRequest(root, errors, exceptions);
        }
        try {
            FileObject esvFile = root.resolveFile("target/metaborg/editor.esv.af");
            esvTerm = !esvFile.exists() ? null : this.esvTerm(root, esvFile);
        }
        catch (IOException | MetaborgException | ParseError e) {
            exceptions.add(e);
            return new ComponentFactoryRequest(root, errors, exceptions);
        }
        SyntaxFacet syntaxFacet = null;
        DynamicClassLoadingFacet dynamicClassLoadingFacet = null;
        StrategoRuntimeFacet strategoRuntimeFacet = null;
        if (esvTerm != null) {
            try {
                syntaxFacet = SyntaxFacetFromESV.create(esvTerm, root);
                if (syntaxFacet != null) {
                    Iterables2.addAll(errors, syntaxFacet.available());
                }
            }
            catch (FileSystemException e) {
                exceptions.add(e);
            }
            try {
                dynamicClassLoadingFacet = DynamicClassLoadingFacetFromESV.create(esvTerm, root);
                if (!dynamicClassLoadingFacet.jarFiles.isEmpty()) {
                    Iterables2.addAll(errors, dynamicClassLoadingFacet.available(this.resourceService));
                }
            }
            catch (IOException e) {
                exceptions.add(e);
            }
            try {
                strategoRuntimeFacet = StrategoRuntimeFacetFromESV.create(esvTerm, root);
                if (!strategoRuntimeFacet.ctreeFiles.isEmpty() || dynamicClassLoadingFacet != null && !dynamicClassLoadingFacet.jarFiles.isEmpty()) {
                    Iterables2.addAll(errors, strategoRuntimeFacet.available(this.resourceService));
                }
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        ComponentFactoryRequest request = errors.isEmpty() && exceptions.isEmpty() ? new ComponentFactoryRequest(root, config, esvTerm, syntaxFacet, dynamicClassLoadingFacet, strategoRuntimeFacet) : new ComponentFactoryRequest(root, errors, exceptions);
        return request;
    }

    private IStrategoAppl esvTerm(FileObject location, FileObject esvFile) throws ParseError, IOException, MetaborgException {
        TermReader reader = new TermReader(this.termFactory);
        IStrategoTerm term = reader.parseFromStream(esvFile.getContent().getInputStream());
        if (!TermUtils.isAppl(term)) {
            String message = logger.format("Cannot discover language at {}, ESV file at {} does not contain a valid ESV term", location, esvFile);
            throw new MetaborgException(message);
        }
        return (IStrategoAppl)term;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ComponentCreationConfig createConfig(IComponentCreationConfigRequest configRequest) throws MetaborgException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl103 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl103 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.binarySort(TimSort.java:296)
         *     at java.base/java.util.TimSort.sort(TimSort.java:221)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Collection<ComponentCreationConfig> createConfigs(Iterable<IComponentCreationConfigRequest> requests) throws MetaborgException {
        ArrayList<ComponentCreationConfig> configs = new ArrayList<ComponentCreationConfig>();
        for (IComponentCreationConfigRequest request : requests) {
            ComponentCreationConfig config = this.createConfig(request);
            configs.add(config);
        }
        return configs;
    }

    private static String[] extensions(IStrategoAppl document) {
        String extensionsStr = ESVReader.getProperty(document, "Extensions");
        if (extensionsStr == null) {
            return new String[0];
        }
        return extensionsStr.split(",");
    }

    @Nullable
    private IContextFactory contextFactory(@Nullable String name) throws MetaborgException {
        if (name == null) {
            return null;
        }
        IContextFactory contextFactory = this.contextFactories.get(name);
        if (contextFactory == null) {
            String message = logger.format("Could not get context factory with name {}", name);
            throw new MetaborgException(message);
        }
        return contextFactory;
    }

    private IContextStrategy contextStrategy(String name) throws MetaborgException {
        IContextStrategy contextStrategy = this.contextStrategies.get(name);
        if (contextStrategy == null) {
            String message = logger.format("Could not get context strategy with name {}", name);
            throw new MetaborgException(message);
        }
        return contextStrategy;
    }
}

