/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego.primitive;

import jakarta.inject.Inject;
import java.io.IOException;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.language.ILanguage;
import org.metaborg.core.language.ILanguageIdentifierService;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageService;
import org.metaborg.core.language.LanguageIdentifier;
import org.metaborg.core.language.LanguageVersion;
import org.metaborg.core.language.dialect.IDialectIdentifier;
import org.metaborg.core.language.dialect.IdentifiedDialect;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.core.source.ISourceTextService;
import org.metaborg.spoofax.core.stratego.primitive.generic.ASpoofaxPrimitive;
import org.metaborg.spoofax.core.syntax.ISpoofaxSyntaxService;
import org.metaborg.spoofax.core.unit.ISpoofaxInputUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxUnitService;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;

public class ParsePrimitive
extends ASpoofaxPrimitive {
    private final IResourceService resourceService;
    private final ILanguageService languageService;
    private final ILanguageIdentifierService languageIdentifierService;
    private final IDialectIdentifier dialectIdentifier;
    private final ISpoofaxUnitService unitService;
    private final ISourceTextService sourceTextService;
    private final ISpoofaxSyntaxService syntaxService;

    @Inject
    public ParsePrimitive(IResourceService resourceService, ILanguageService languageService, ILanguageIdentifierService languageIdentifierService, IDialectIdentifier dialectIdentifier, ISpoofaxUnitService unitService, ISourceTextService sourceTextService, ISpoofaxSyntaxService syntaxService) {
        super("parse", 0, 4);
        this.resourceService = resourceService;
        this.languageService = languageService;
        this.languageIdentifierService = languageIdentifierService;
        this.dialectIdentifier = dialectIdentifier;
        this.unitService = unitService;
        this.sourceTextService = sourceTextService;
        this.syntaxService = syntaxService;
    }

    @Override
    protected IStrategoTerm call(IStrategoTerm current, Strategy[] svars, IStrategoTerm[] tvars, ITermFactory factory, IContext strategoContext) throws MetaborgException, IOException {
        ISpoofaxInputUnit input;
        ILanguageImpl langImpl;
        String text;
        FileObject file;
        if (!TermUtils.isString(current)) {
            throw new MetaborgException("Cannot parse, input string or file " + current + " is not a string");
        }
        String stringOrFile = ((IStrategoString)current).stringValue();
        IStrategoTerm isFileTerm = tvars[0];
        if (!TermUtils.isInt(isFileTerm)) {
            throw new MetaborgException("Cannot parse, input kind " + isFileTerm + " is not an integer");
        }
        if (((IStrategoInt)isFileTerm).intValue() == 1) {
            file = this.resourceService.resolve(stringOrFile);
            if (!file.exists() || !file.isFile()) {
                throw new MetaborgException("Cannot parse, input file " + file + " does not exist or is not a file");
            }
            text = this.sourceTextService.text(file);
        } else {
            file = null;
            text = stringOrFile;
        }
        IStrategoTerm nameOrGroupIdTerm = tvars[1];
        IStrategoTerm idTerm = tvars[2];
        IStrategoTerm versionTerm = tvars[3];
        if (TermUtils.isTuple(nameOrGroupIdTerm)) {
            if (file == null) {
                throw new MetaborgException("Cannot parse a string, no language to parse it with was given");
            }
            org.metaborg.core.context.IContext context = this.metaborgContext(strategoContext);
            langImpl = context != null ? this.languageIdentifierService.identify(file, context.project()) : this.languageIdentifierService.identify(file);
            if (langImpl == null) {
                throw new MetaborgException("Cannot parse, language for " + file + " could not be identified");
            }
        } else if (TermUtils.isTuple(idTerm)) {
            if (!TermUtils.isString(nameOrGroupIdTerm)) {
                throw new MetaborgException("Cannot parse, language name " + nameOrGroupIdTerm + " is not a string");
            }
            String name = ((IStrategoString)nameOrGroupIdTerm).stringValue();
            ILanguage lang = this.languageService.getLanguage(name);
            if (lang == null) {
                throw new MetaborgException("Cannot parse, language " + nameOrGroupIdTerm + " does not exist");
            }
            langImpl = lang.activeImpl();
            if (langImpl == null) {
                throw new MetaborgException("Cannot parse, language " + lang + " has no implementation loaded");
            }
        } else {
            if (!TermUtils.isString(nameOrGroupIdTerm)) {
                throw new MetaborgException("Cannot parse, language groupId " + nameOrGroupIdTerm + " is not a string");
            }
            String groupId = ((IStrategoString)nameOrGroupIdTerm).stringValue();
            if (!TermUtils.isString(idTerm)) {
                throw new MetaborgException("Cannot parse, language id " + idTerm + " is not a string");
            }
            String id = ((IStrategoString)idTerm).stringValue();
            if (!TermUtils.isString(versionTerm)) {
                throw new MetaborgException("Cannot parse, language version " + versionTerm + " is not a string");
            }
            String versionStr = ((IStrategoString)versionTerm).stringValue();
            LanguageVersion version = LanguageVersion.parse(versionStr);
            LanguageIdentifier langId = new LanguageIdentifier(groupId, id, version);
            langImpl = this.languageService.getImpl(langId);
            if (langImpl == null) {
                throw new MetaborgException("Cannot parse, language implementation " + langId + " does not exist");
            }
        }
        if (file != null) {
            ILanguageImpl dialect;
            try {
                IdentifiedDialect identifierDialect = this.dialectIdentifier.identify(file);
                dialect = identifierDialect != null ? identifierDialect.dialect : null;
            }
            catch (MetaborgException | MetaborgRuntimeException e) {
                dialect = null;
            }
            input = (ISpoofaxInputUnit)this.unitService.inputUnit(file, text, langImpl, dialect);
        } else {
            input = (ISpoofaxInputUnit)this.unitService.inputUnit(text, langImpl, null);
        }
        ISpoofaxParseUnit result = (ISpoofaxParseUnit)this.syntaxService.parse(input);
        if (result.valid() && result.success()) {
            return result.ast();
        }
        return null;
    }
}

