/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.iterators;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.metaborg.util.iterators.ArrayIterable;
import org.metaborg.util.iterators.CompoundIterable;
import org.metaborg.util.iterators.ConsIterable;
import org.metaborg.util.iterators.IteratorIterable;
import org.metaborg.util.iterators.IteratorIterableOnce;
import org.metaborg.util.iterators.Zip2Iterable;
import org.metaborg.util.iterators.Zip2Iterator;

public final class Iterables2 {
    public static <T> Iterable<T> empty() {
        return Collections.emptyList();
    }

    public static <T> Iterable<T> singleton(T t) {
        return Collections.singletonList(t);
    }

    @SafeVarargs
    public static <T> Iterable<T> from(T ... array) {
        return new ArrayIterable<T>(array);
    }

    public static <T> Iterable<T> cons(T head, Iterable<T> tail) {
        return new ConsIterable<T>(head, tail);
    }

    public static <T> Iterable<T> from(Supplier<Iterator<T>> iteratorGenerator) {
        return new IteratorIterable<T>(iteratorGenerator);
    }

    public static <T> Iterable<T> fromOnce(Iterator<T> iterator) {
        return new IteratorIterableOnce<T>(iterator);
    }

    public static <T> Iterable<T> fromConcat(Iterable<? extends Iterable<? extends T>> iterables) {
        return new CompoundIterable(iterables);
    }

    @SafeVarargs
    public static <T> Iterable<T> fromConcat(Iterable<? extends T> ... iterablesArray) {
        return Iterables2.fromConcat(Iterables2.from(iterablesArray));
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T1, T2, R> Iterable<R> zip(Iterable<T1> iterable1, Iterable<T2> iterable2, BiFunction<? super T1, ? super T2, R> combine) {
        return new Zip2Iterable<T1, T2, R>(iterable1, iterable2, combine);
    }

    public static <T> boolean addAll(Collection<T> collection, Iterable<? extends T> toAdd) {
        if (toAdd instanceof Collection) {
            return collection.addAll((Collection)toAdd);
        }
        boolean added = false;
        for (T t : toAdd) {
            added |= collection.add(t);
        }
        return added;
    }

    public static <E> ArrayList<E> toArrayList(Iterable<? extends E> iterable) {
        if (iterable instanceof Collection) {
            return new ArrayList((Collection)iterable);
        }
        ArrayList<E> result = new ArrayList<E>();
        for (E e : iterable) {
            result.add(e);
        }
        return result;
    }

    public static <E> HashSet<E> toHashSet(Iterable<? extends E> iterable) {
        if (iterable instanceof Collection) {
            return new HashSet((Collection)iterable);
        }
        HashSet<E> result = new HashSet<E>();
        for (E e : iterable) {
            result.add(e);
        }
        return result;
    }

    public static <E> E[] toArray(Iterable<E> iterable, Class<E> elementClass) {
        ArrayList<E> es = Iterables2.toArrayList(iterable);
        return es.toArray((Object[])Array.newInstance(elementClass, es.size()));
    }

    public static <E> boolean isEmpty(Iterable<E> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return !iterable.iterator().hasNext();
    }

    public static <T> int size(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int size = 0;
        for (T t : iterable) {
            ++size;
        }
        return size;
    }

    public static <T> boolean contains(Iterable<? extends T> iterable, T elem) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).contains(elem);
        }
        for (T t : iterable) {
            if (!elem.equals(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean elementsEqual(Iterable<T> iterable1, Iterable<T> iterable2) {
        Zip2Iterator<Object, Object, Boolean> zippedEquals;
        if (iterable1 instanceof Collection && iterable2 instanceof Collection) {
            Collection collection1 = (Collection)iterable1;
            Collection collection2 = (Collection)iterable2;
            if (collection1.size() != collection2.size()) {
                return false;
            }
        }
        Iterator<T> iterator1 = iterable1.iterator();
        Iterator<T> iterator2 = iterable2.iterator();
        Zip2Iterator<Object, Object, Boolean> iterator = zippedEquals = new Zip2Iterator<Object, Object, Boolean>(iterator1, iterator2, Objects::equals);
        while (iterator.hasNext()) {
            Boolean equals = (Boolean)iterator.next();
            if (equals.booleanValue()) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static <T> T getOnlyElement(Iterable<T> actionContributions) {
        Iterator<T> iterator = actionContributions.iterator();
        T result = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("Iterable had more than 1 element");
        }
        return result;
    }
}

