/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.index;

import mb.jsglr.shared.ImploderAttachment;
import org.spoofax.interpreter.library.index.IndexEntry;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.attachments.TermAttachmentStripper;

public class IndexEntryFactory {
    private final ITermFactory factory;
    private final TermAttachmentStripper stripper;

    public IndexEntryFactory(ITermFactory termFactory) {
        this.factory = termFactory;
        this.stripper = new TermAttachmentStripper(termFactory);
    }

    public ITermFactory getTermFactory() {
        return this.factory;
    }

    public IndexEntry create(IStrategoTerm key, IStrategoTerm value, IStrategoTerm source) {
        ImploderAttachment origin = this.getImploderAttachment(value);
        key = this.stripper.strip(key);
        value = this.stripper.strip(value);
        if (origin != null) {
            ImploderAttachment.putImploderAttachment(value, false, origin.getSort(), origin.getLeftToken(), origin.getRightToken(), origin.isBracket(), origin.isCompletion(), origin.isNestedCompletion(), origin.isSinglePlaceholderCompletion());
        }
        IndexEntry entry = new IndexEntry(key, value, source, origin);
        return entry;
    }

    public IndexEntry create(IStrategoTerm key, IStrategoTerm source) {
        ImploderAttachment origin = this.getImploderAttachment(key);
        key = this.stripper.strip(key);
        if (origin != null) {
            ImploderAttachment.putImploderAttachment(key, false, origin.getSort(), origin.getLeftToken(), origin.getRightToken(), origin.isBracket(), origin.isCompletion(), origin.isNestedCompletion(), origin.isSinglePlaceholderCompletion());
        }
        IndexEntry entry = new IndexEntry(key, source, origin);
        return entry;
    }

    private ImploderAttachment getImploderAttachment(IStrategoTerm term) {
        IStrategoTerm termWithImploder = ImploderAttachment.getImploderOrigin(term);
        if (termWithImploder == null) {
            return null;
        }
        return ImploderAttachment.get(termWithImploder);
    }

    public IStrategoTerm toPair(IndexEntry entry) {
        return this.factory.makeTuple(entry.key, entry.value);
    }

    public IStrategoTerm toTerm(IndexEntry entry) {
        if (entry.origin != null) {
            return this.factory.makeTuple(entry.key, entry.value, entry.source, ImploderAttachment.TYPE.toTerm(this.factory, entry.origin));
        }
        return this.factory.makeTuple(entry.key, entry.value, entry.source);
    }

    public IStrategoList toKeyTerms(Iterable<IndexEntry> entries) {
        IStrategoList list = this.factory.makeList();
        for (IndexEntry entry : entries) {
            list = this.factory.makeListCons(entry.key, list);
        }
        return list;
    }

    public IStrategoList toValueTerms(Iterable<IndexEntry> entries) {
        IStrategoList list = this.factory.makeList();
        for (IndexEntry entry : entries) {
            list = this.factory.makeListCons(entry.value, list);
        }
        return list;
    }

    public IStrategoList toPairTerms(Iterable<IndexEntry> entries) {
        IStrategoList list = this.factory.makeList();
        for (IndexEntry entry : entries) {
            list = this.factory.makeListCons(this.toPair(entry), list);
        }
        return list;
    }

    public IndexEntry fromTerm(IStrategoTerm term) {
        IStrategoTerm key = term.getSubterm(0);
        IStrategoTerm value = term.getSubterm(1);
        IStrategoTerm source = term.getSubterm(2);
        if (term.getSubtermCount() == 3) {
            return new IndexEntry(key, value, source, null);
        }
        ImploderAttachment origin = ImploderAttachment.TYPE.fromTerm((IStrategoAppl)term.getSubterm(3));
        return new IndexEntry(key, value, source, origin);
    }
}

