/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.spoofax.jsglr2.messages.Message;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parseforest.ParseNodeVisitor;
import org.spoofax.jsglr2.parser.Position;
import org.spoofax.jsglr2.parser.result.ParseFailureCause;

public class CycleDetector<ParseForest extends IParseForest, Derivation extends IDerivation<ParseForest>, ParseNode extends IParseNode<ParseForest, Derivation>>
implements ParseNodeVisitor<ParseForest, Derivation, ParseNode> {
    Collection<Message> messages;
    List<ParseNode> spine = new ArrayList<ParseNode>();
    ParseFailureCause failureCause = null;

    CycleDetector(Collection<Message> messages) {
        this.messages = messages;
    }

    @Override
    public boolean preVisit(ParseNode parseNode, Position startPosition) {
        if (this.spine.contains(parseNode)) {
            this.failureCause = new ParseFailureCause(ParseFailureCause.Type.Cycle, startPosition, this.cycleDescription(parseNode));
            this.messages.add(this.failureCause.toMessage());
            return false;
        }
        this.spine.add(parseNode);
        return parseNode.production().isContextFree();
    }

    public boolean cycleDetected() {
        return this.failureCause != null;
    }

    private String cycleDescription(ParseNode parseNode) {
        int cycleStartIndex = this.spine.size() - 1;
        while (this.spine.get(cycleStartIndex) != parseNode) {
            --cycleStartIndex;
        }
        List<ParseNode> cycle = this.spine.subList(cycleStartIndex, this.spine.size());
        cycle.add(parseNode);
        return cycle.stream().map(IParseNode::descriptor).collect(Collectors.joining(" -> "));
    }

    @Override
    public void postVisit(ParseNode parseNode, Position startPosition, Position endPosition) {
        this.spine.remove(parseNode);
    }
}

