/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.tokens;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import mb.jsglr.shared.FilteredTokenIterator;
import mb.jsglr.shared.IToken;
import mb.jsglr.shared.Token;
import org.metaborg.parsetable.productions.IProduction;
import org.spoofax.jsglr2.parser.Position;
import org.spoofax.jsglr2.tokens.IParseTokens;

public class Tokens
implements IParseTokens {
    private static final long serialVersionUID = 2054391299757162697L;
    private final String fileName;
    private final String input;
    private IToken startToken;
    private IToken endToken;
    private final ArrayList<IToken> tokens;

    public Tokens(String input, String fileName) {
        this.input = input;
        this.fileName = fileName;
        this.tokens = new ArrayList();
    }

    @Override
    public IToken startToken() {
        return this.startToken;
    }

    @Override
    public IToken endToken() {
        return this.endToken;
    }

    @Override
    public void makeStartToken() {
        this.startToken = new Token(this, this.fileName, 0, 1, 1, 0, -1, IToken.Kind.TK_RESERVED);
        this.tokens.add(this.startToken);
    }

    @Override
    public void makeEndToken(Position endPosition) {
        this.endToken = new Token(this, this.fileName, this.tokens.size(), endPosition.line, endPosition.column, endPosition.offset, -1, IToken.Kind.TK_EOF);
        this.tokens.add(this.endToken);
    }

    @Override
    public IToken makeToken(Position startPosition, Position endPosition, IProduction production) {
        Token token = new Token(this, this.fileName, this.tokens.size(), startPosition.line, startPosition.column, startPosition.offset, endPosition.offset - 1, startPosition.equals(endPosition) ? IToken.Kind.TK_NO_TOKEN_KIND : IProduction.getTokenKind(production));
        this.tokens.add(token);
        return token;
    }

    @Override
    @Nonnull
    public Iterator<IToken> iterator() {
        return new FilteredTokenIterator(this.allTokens());
    }

    @Override
    @Nonnull
    public Iterable<IToken> allTokens() {
        return Collections.unmodifiableList(this.tokens);
    }

    @Override
    public String getInput() {
        return this.input;
    }

    @Override
    public int getTokenCount() {
        return this.tokens.size();
    }

    @Override
    public IToken getTokenAtOffset(int offset) {
        for (IToken token : this.tokens) {
            if (token.getStartOffset() != offset) continue;
            return token;
        }
        return null;
    }

    @Override
    public String getFilename() {
        return this.fileName;
    }

    @Override
    public String toString(IToken left, IToken right) {
        int startOffset = left.getStartOffset();
        int endOffset = right.getEndOffset();
        if (startOffset >= 0 && endOffset >= 0) {
            return this.toString(startOffset, endOffset + 1);
        }
        return "";
    }

    @Override
    public String toString(int startOffset, int endOffset) {
        return this.input.substring(startOffset, endOffset);
    }

    public String toString() {
        return this.tokens.toString();
    }
}

