/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AbstractRdbmsEntityProviderConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.ForeignKeyColumnConfig;
import oracle.pgx.config.GraphErrorHandlingConfig;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.KeyColumnConfig;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PropertiesConfigParser;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.config.ProviderLoadingConfig;

public class RdbmsEntityProviderConfig
extends AbstractRdbmsEntityProviderConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static RdbmsEntityProviderConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return RdbmsEntityProviderConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static RdbmsEntityProviderConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return RdbmsEntityProviderConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static RdbmsEntityProviderConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new RdbmsEntityProviderConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static RdbmsEntityProviderConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new RdbmsEntityProviderConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static RdbmsEntityProviderConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new RdbmsEntityProviderConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected RdbmsEntityProviderConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    @Override
    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    @Override
    public String getDatabaseTableName() {
        return (String)this.values.get(Field.DATABASE_TABLE_NAME);
    }

    public String getAsOf() {
        return (String)this.values.get(Field.AS_OF);
    }

    public Integer getParallelHintDegree() {
        return (Integer)this.values.get(Field.PARALLEL_HINT_DEGREE);
    }

    @Override
    public String getKeyColumn() {
        return (String)this.values.get(Field.KEY_COLUMN);
    }

    @Override
    public String getSourceColumn() {
        return (String)this.values.get(Field.SOURCE_COLUMN);
    }

    public List<ForeignKeyColumnConfig> getSourceKeyColumns() {
        return (List)this.values.get(Field.SOURCE_KEY_COLUMNS);
    }

    @Override
    public String getDestinationColumn() {
        return (String)this.values.get(Field.DESTINATION_COLUMN);
    }

    public List<ForeignKeyColumnConfig> getDestinationKeyColumns() {
        return (List)this.values.get(Field.DESTINATION_KEY_COLUMNS);
    }

    @Override
    public Integer getNumConnections() {
        return (Integer)this.values.get(Field.NUM_CONNECTIONS);
    }

    @Override
    public String getSchema() {
        return (String)this.values.get(Field.SCHEMA);
    }

    @Override
    public String getJdbcUrl() {
        return (String)this.values.get(Field.JDBC_URL);
    }

    @Override
    public String getUsername() {
        return (String)this.values.get(Field.USERNAME);
    }

    @Override
    public String getDataSourceId() {
        return (String)this.values.get(Field.DATA_SOURCE_ID);
    }

    @Override
    public Integer getMaxPrefetchedRows() {
        return (Integer)this.values.get(Field.MAX_PREFETCHED_ROWS);
    }

    @Override
    public String getName() {
        return (String)this.values.get(Field.NAME);
    }

    @Override
    public String getLabel() {
        return (String)this.values.get(Field.LABEL);
    }

    @Override
    public ProviderFormat getFormat() {
        return (ProviderFormat)((Object)this.values.get(Field.FORMAT));
    }

    @Override
    public List<GraphPropertyConfig> getProps() {
        return (List)this.values.get(Field.PROPS);
    }

    @Override
    public IdType getKeyType() {
        return (IdType)this.values.get(Field.KEY_TYPE);
    }

    public List<KeyColumnConfig> getKeyColumns() {
        return (List)this.values.get(Field.KEY_COLUMNS);
    }

    @Override
    public String getSourceVertexProvider() {
        return (String)this.values.get(Field.SOURCE_VERTEX_PROVIDER);
    }

    @Override
    public String getDestinationVertexProvider() {
        return (String)this.values.get(Field.DESTINATION_VERTEX_PROVIDER);
    }

    @Override
    public ProviderLoadingConfig getLoading() {
        return (ProviderLoadingConfig)this.values.get(Field.LOADING);
    }

    @Override
    public Boolean hasKeys() {
        return (Boolean)this.values.get(Field.HAS_KEYS);
    }

    @Override
    public GraphErrorHandlingConfig getErrorHandling() {
        return (GraphErrorHandlingConfig)this.values.get(Field.ERROR_HANDLING);
    }

    @Override
    public List<String> getLocalDateFormat() {
        return (List)this.values.get(Field.LOCAL_DATE_FORMAT);
    }

    @Override
    public List<String> getTimeFormat() {
        return (List)this.values.get(Field.TIME_FORMAT);
    }

    @Override
    public List<String> getTimestampFormat() {
        return (List)this.values.get(Field.TIMESTAMP_FORMAT);
    }

    @Override
    public List<String> getTimeWithTimezoneFormat() {
        return (List)this.values.get(Field.TIME_WITH_TIMEZONE_FORMAT);
    }

    @Override
    public List<String> getTimestampWithTimezoneFormat() {
        return (List)this.values.get(Field.TIMESTAMP_WITH_TIMEZONE_FORMAT);
    }

    @Override
    public Character getVectorComponentDelimiter() {
        return (Character)this.values.get(Field.VECTOR_COMPONENT_DELIMITER);
    }

    public String getPoint2d() {
        return (String)this.values.get(Field.POINT2D);
    }

    @Override
    public Map getAttributes() {
        return (Map)this.values.get(Field.ATTRIBUTES);
    }

    @Override
    public String getKeystoreAlias() {
        return (String)this.values.get(Field.KEYSTORE_ALIAS);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RdbmsEntityProviderConfig other = (RdbmsEntityProviderConfig)obj;
        if (!Objects.equals(this.getLoadedDatabaseTableName(), other.getLoadedDatabaseTableName())) {
            return false;
        }
        if (!Objects.equals(this.getAsOf(), other.getAsOf())) {
            return false;
        }
        if (!Objects.equals(this.getParallelHintDegree(), other.getParallelHintDegree())) {
            return false;
        }
        if (!Objects.equals(this.getKeyColumn(), other.getKeyColumn())) {
            return false;
        }
        if (!Objects.equals(this.getSourceColumn(), other.getSourceColumn())) {
            return false;
        }
        if (!Objects.equals(this.getSourceKeyColumns(), other.getSourceKeyColumns())) {
            return false;
        }
        if (!Objects.equals(this.getDestinationColumn(), other.getDestinationColumn())) {
            return false;
        }
        if (!Objects.equals(this.getDestinationKeyColumns(), other.getDestinationKeyColumns())) {
            return false;
        }
        if (!Objects.equals(this.getNumConnections(), other.getNumConnections())) {
            return false;
        }
        if (!Objects.equals(this.getSchema(), other.getSchema())) {
            return false;
        }
        if (!Objects.equals(this.getJdbcUrl(), other.getJdbcUrl())) {
            return false;
        }
        if (!Objects.equals(this.getUsername(), other.getUsername())) {
            return false;
        }
        if (!Objects.equals(this.getDataSourceId(), other.getDataSourceId())) {
            return false;
        }
        if (!Objects.equals(this.getMaxPrefetchedRows(), other.getMaxPrefetchedRows())) {
            return false;
        }
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getLabel(), other.getLabel())) {
            return false;
        }
        if (!Objects.equals((Object)this.getFormat(), (Object)other.getFormat())) {
            return false;
        }
        if (!Objects.equals(this.getProps(), other.getProps())) {
            return false;
        }
        if (!Objects.equals(this.getKeyType(), other.getKeyType())) {
            return false;
        }
        if (!Objects.equals(this.getKeyColumns(), other.getKeyColumns())) {
            return false;
        }
        if (!Objects.equals(this.getSourceVertexProvider(), other.getSourceVertexProvider())) {
            return false;
        }
        if (!Objects.equals(this.getDestinationVertexProvider(), other.getDestinationVertexProvider())) {
            return false;
        }
        if (!Objects.equals(this.getLoading(), other.getLoading())) {
            return false;
        }
        if (!Objects.equals(this.hasKeys(), other.hasKeys())) {
            return false;
        }
        if (!Objects.equals(this.getErrorHandling(), other.getErrorHandling())) {
            return false;
        }
        if (!Objects.equals(this.getLocalDateFormat(), other.getLocalDateFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimeFormat(), other.getTimeFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimestampFormat(), other.getTimestampFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimeWithTimezoneFormat(), other.getTimeWithTimezoneFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimestampWithTimezoneFormat(), other.getTimestampWithTimezoneFormat())) {
            return false;
        }
        if (!Objects.equals(this.getVectorComponentDelimiter(), other.getVectorComponentDelimiter())) {
            return false;
        }
        if (!Objects.equals(this.getPoint2d(), other.getPoint2d())) {
            return false;
        }
        if (!Objects.equals(this.getAttributes(), other.getAttributes())) {
            return false;
        }
        if (!Objects.equals(this.values.get(Field.PASSWORD), other.values.get(Field.PASSWORD))) {
            return false;
        }
        return Objects.equals(this.getKeystoreAlias(), other.getKeystoreAlias());
    }

    public static enum Field implements ConfigField
    {
        DATABASE_TABLE_NAME(Arrays.asList("data_table_name"), Collections.emptyList(), String.class, false, null, false, false, false, false),
        AS_OF(Collections.emptyList(), Collections.emptyList(), String.class, false, "<current-scn>", false, false, false, false),
        PARALLEL_HINT_DEGREE(Collections.emptyList(), Collections.emptyList(), Integer.class, false, -1, false, false, false, false),
        KEY_COLUMN(Collections.emptyList(), Collections.emptyList(), String.class, false, "KEY", false, false, false, false),
        SOURCE_COLUMN(Collections.emptyList(), Collections.emptyList(), String.class, false, "SVKEY", false, false, false, false),
        SOURCE_KEY_COLUMNS(Collections.emptyList(), Collections.emptyList(), ForeignKeyColumnConfig.class, false, Collections.emptyList(), true, false, false, false),
        DESTINATION_COLUMN(Collections.emptyList(), Collections.emptyList(), String.class, false, "DVKEY", false, false, false, false),
        DESTINATION_KEY_COLUMNS(Collections.emptyList(), Collections.emptyList(), ForeignKeyColumnConfig.class, false, Collections.emptyList(), true, false, false, false),
        NUM_CONNECTIONS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, "<no-of-CPUs>", false, false, false, false),
        SCHEMA(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        JDBC_URL(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        USERNAME(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        DATA_SOURCE_ID(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        MAX_PREFETCHED_ROWS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 10000, false, false, false, false),
        NAME(Collections.emptyList(), Collections.emptyList(), String.class, true, null, false, false, false, false),
        LABEL(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        FORMAT(Collections.emptyList(), Collections.emptyList(), ProviderFormat.class, true, null, false, false, false, false),
        PROPS(Collections.emptyList(), Collections.emptyList(), GraphPropertyConfig.class, false, Collections.emptyList(), true, false, false, false),
        KEY_TYPE(Collections.emptyList(), Collections.emptyList(), IdType.class, false, IdType.LONG, false, false, false, false),
        KEY_COLUMNS(Collections.emptyList(), Collections.emptyList(), KeyColumnConfig.class, false, Collections.emptyList(), true, false, false, false),
        SOURCE_VERTEX_PROVIDER(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        DESTINATION_VERTEX_PROVIDER(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        LOADING(Collections.emptyList(), Collections.emptyList(), ProviderLoadingConfig.class, false, Collections.emptyMap(), false, false, false, false),
        HAS_KEYS(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        ERROR_HANDLING(Collections.emptyList(), Collections.emptyList(), GraphErrorHandlingConfig.class, false, Collections.emptyMap(), false, false, false, false),
        LOCAL_DATE_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("yyyy-M[M]-d[d]", "M[M]/d[d]/yyyy", "d[d]-MMM-yyyy", "d[d]-M[M]-yyyy", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIME_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("h[h]:m[m][:s[s][.SSS]] a[ XXX]", "[yyyy-MM-dd'T']H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIMESTAMP_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIME_WITH_TIMEZONE_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("h[h]:m[m][:s[s]] a[ XXX]", "[yyyy-MM-dd'T']H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIMESTAMP_WITH_TIMEZONE_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        VECTOR_COMPONENT_DELIMITER(Collections.emptyList(), Collections.emptyList(), Character.class, false, Character.valueOf(';'), false, false, false, false),
        POINT2D(Collections.emptyList(), Collections.emptyList(), String.class, false, "0.0 0.0", false, false, false, false),
        ATTRIBUTES(Collections.emptyList(), Collections.emptyList(), Map.class, false, Collections.emptyMap(), false, false, false, false),
        PASSWORD(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, true, true),
        KEYSTORE_ALIAS(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("rdbms.entity.provider.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

