/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.mllib.batchgenerator.BatchGenerator;
import oracle.pgx.config.mllib.batchgenerator.StandardBatchGenerator;
import oracle.pgx.config.mllib.batchgenerator.StratifiedOversamplingBatchGenerator;

public class BatchGeneratorDeserializer
extends JsonDeserializer<BatchGenerator> {
    private static BatchGenerator getBatchGenerator(JsonNode jsonNode) throws JsonProcessingException {
        JsonNode batchGeneratorTypeNode = jsonNode.get("batchGeneratorType");
        BatchGenerator.BatchGeneratorType batchGeneratorType = ConfigJsonUtil.fromJsonNode(batchGeneratorTypeNode, BatchGenerator.BatchGeneratorType.class);
        switch (batchGeneratorType) {
            case STANDARD: {
                return new StandardBatchGenerator();
            }
            case STRATIFIED_OVERSAMPLE: {
                return new StratifiedOversamplingBatchGenerator();
            }
        }
        throw new IllegalEnumConstantException((Enum)batchGeneratorType);
    }

    public BatchGenerator deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        return BatchGeneratorDeserializer.getBatchGenerator(jsonNode);
    }
}

