/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import oracle.pgx.api.internal.AllPathsProxy;
import oracle.pgx.api.internal.PathProxy;
import oracle.pgx.api.internal.ProxyException;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.marshalers.Marshalers;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.config.LinkTemplate;
import org.apache.hc.client5.http.fluent.Executor;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAllPathsProxy
implements AllPathsProxy {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteAllPathsProxy.class);
    private final Executor httpExecutor;
    private final String allPathsProxyUUID;
    private final URI baseUri;

    public RemoteAllPathsProxy(Executor httpExecutor, URI baseUri, String allPathsProxyUUID) {
        this.httpExecutor = httpExecutor;
        this.baseUri = baseUri;
        this.allPathsProxyUUID = allPathsProxyUUID;
    }

    public String getId() {
        throw new UnsupportedOperationException("getId() should never be called on RemoteAllPathsProxy");
    }

    public PathProxy getPath(Object dst) {
        try {
            Object dstId = dst instanceof Vertex ? JsonUtil.toJson((Object)dst) : dst;
            URIBuilder builder = new URIBuilder(LinkTemplate.ALLPATH_PROXY_PATH_SELF.generateUrl(this.baseUri, new Object[0]));
            builder.addParameter("destValueWrapped", Boolean.valueOf(dst instanceof Vertex).toString());
            builder.addParameter("destValueType", IdType.getTypeFor(dstId.getClass()).name());
            Request r = Request.get((URI)builder.build());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Requesting {}", (Object)r);
            }
            r.addHeader("x-proxy-id", this.allPathsProxyUUID);
            r.addHeader("x-destination", dstId.toString());
            return (PathProxy)RemoteUtils.parse(this.httpExecutor.execute(r), Marshalers.PATH_PROXY_MARSHALER);
        }
        catch (IOException | URISyntaxException | RemoteUtils.RequestPendingException e) {
            throw new ProxyException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new ProxyException(e.getCause());
        }
    }
}

