/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.pgql.lang.PgqlException;
import oracle.pgx.api.PgqlResultElement;
import oracle.pgx.api.internal.ProxyException;
import oracle.pgx.client.RemoteIteratorUtils;
import oracle.pgx.common.util.ErrorMessages;
import org.apache.hc.client5.http.fluent.Executor;

public class RemotePgqlResultSetBuffer {
    private Executor httpExecutor;
    private String requestUrl;
    private String resultSetProxyId;
    private List<PgqlResultElement> resultElements;
    private List<List<Object>> bufferedResultRows;
    private int bufferSize;
    private long leftBoundary;
    private long rightBoundary;
    private long maxNumResult;

    public RemotePgqlResultSetBuffer(int bufferSize, long maxNumResult, Executor httpExecutor, String requestUrl, String resultSetProxyId, List<PgqlResultElement> resultElements) {
        this.bufferedResultRows = new ArrayList<List<Object>>(bufferSize);
        this.bufferSize = bufferSize;
        this.maxNumResult = maxNumResult;
        this.httpExecutor = httpExecutor;
        this.requestUrl = requestUrl;
        this.resultSetProxyId = resultSetProxyId;
        this.resultElements = resultElements;
        this.leftBoundary = 0L;
        this.rightBoundary = 0L;
    }

    public List<Object> getResultRow(long cursor) throws PgqlException {
        if (!this.availableInBuffer(cursor)) {
            try {
                this.fetchResultRows(cursor);
            }
            catch (ProxyException e) {
                throw new PgqlException(ErrorMessages.getMessage((String)"FETCH_RESULT_ROWS_ERROR", (Object[])new Object[0]), (Throwable)e);
            }
        }
        return this.getBufferedRow(cursor);
    }

    private boolean availableInBuffer(long cursor) {
        return cursor >= this.leftBoundary && cursor <= this.rightBoundary;
    }

    private List<Object> getBufferedRow(long cursor) {
        return this.bufferedResultRows.get((int)(cursor - this.leftBoundary));
    }

    private void fetchResultRows(long cursor) throws ProxyException {
        long newRightBoundary;
        long newLeftBoundary;
        long left = cursor - (long)((this.bufferSize - 1) / 2);
        long right = cursor + (long)(this.bufferSize / 2);
        if (left < 1L) {
            newLeftBoundary = 1L;
            newRightBoundary = Math.min((long)this.bufferSize, this.maxNumResult);
        } else if (right > this.maxNumResult) {
            newLeftBoundary = this.maxNumResult - (long)this.bufferSize + 1L;
            newRightBoundary = this.maxNumResult;
        } else {
            newLeftBoundary = left;
            newRightBoundary = right;
        }
        this.buildNewBuffer(newLeftBoundary, newRightBoundary);
        this.leftBoundary = newLeftBoundary;
        this.rightBoundary = newRightBoundary;
    }

    private void buildNewBuffer(long newLeftBoundary, long newRightBoundary) {
        ArrayList<List<Object>> overlappingRowsLeft = new ArrayList<List<Object>>();
        if (newRightBoundary > this.rightBoundary && newLeftBoundary < this.rightBoundary) {
            for (long i = newLeftBoundary; i <= this.rightBoundary; ++i) {
                overlappingRowsLeft.add(this.getBufferedRow(i));
            }
        }
        ArrayList<List<Object>> overlappingRowsRight = new ArrayList<List<Object>>();
        if (newLeftBoundary < this.leftBoundary && newRightBoundary > this.leftBoundary) {
            for (long i = this.leftBoundary; i <= newRightBoundary; ++i) {
                overlappingRowsRight.add(this.getBufferedRow(i));
            }
        }
        long nonOverlapSize = this.bufferSize - overlappingRowsLeft.size() - overlappingRowsRight.size();
        Collection<List<Object>> nonOverlappingRows = this.fetch(newLeftBoundary + (long)overlappingRowsLeft.size(), Math.min(nonOverlapSize, this.maxNumResult + 1L - newLeftBoundary));
        this.bufferedResultRows.clear();
        this.bufferedResultRows.addAll(overlappingRowsLeft);
        this.bufferedResultRows.addAll(nonOverlappingRows);
        this.bufferedResultRows.addAll(overlappingRowsRight);
    }

    private Collection<List<Object>> fetch(long start, long size) throws ProxyException {
        String response = RemoteIteratorUtils.prefetch(this.httpExecutor, this.requestUrl, this.resultSetProxyId, start - 1L, size);
        try {
            return RemoteIteratorUtils.parseResults(response, this.bufferSize, this.resultElements);
        }
        catch (IOException e) {
            throw new ProxyException("FETCH_RESULT_ROWS_ERROR", (Throwable)e);
        }
    }
}

