/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import com.fasterxml.jackson.annotation.JsonView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import oracle.pgx.api.PropertyMetaData;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.internal.compat.MetaDataCompatibilityVersion;
import oracle.pgx.api.keys.DefaultKeyColumnDescriptors;
import oracle.pgx.api.keys.KeyColumnDescriptor;
import oracle.pgx.api.keys.KeyUtils;
import oracle.pgx.common.Self;
import oracle.pgx.common.types.IdType;

public abstract class EntityProviderMetaData
extends Self {
    protected List<KeyColumnDescriptor> keyColumns;
    protected final String name;
    protected final Set<String> labels;
    protected List<PropertyMetaData> properties;

    @Deprecated
    protected EntityProviderMetaData(String name, IdType idType, Set<String> labels, List<PropertyMetaData> properties) {
        this(name, EntityProviderMetaData.asKey(idType), labels, properties);
    }

    protected EntityProviderMetaData(String name, List<KeyColumnDescriptor> keyColumns, Set<String> labels, List<PropertyMetaData> properties) {
        this.name = name;
        this.keyColumns = keyColumns;
        this.labels = labels;
        this.properties = properties;
    }

    protected EntityProviderMetaData(EntityProviderMetaData other) {
        this(other.name, new ArrayList<KeyColumnDescriptor>(other.keyColumns), new HashSet<String>(other.labels), new ArrayList<PropertyMetaData>(other.properties));
    }

    @JsonView(value={MetaDataCompatibilityVersion.Current25Dot2.class})
    @BetaApi
    public List<KeyColumnDescriptor> getKeyColumns() {
        return Collections.unmodifiableList(this.keyColumns);
    }

    @BetaApi
    public void setKeyColumns(List<KeyColumnDescriptor> keyColumns) {
        this.keyColumns = keyColumns;
    }

    @JsonView(value={MetaDataCompatibilityVersion.Legacy25Dot1Only.class})
    public IdType getIdType() {
        return this.keyColumns == null ? null : KeyUtils.getType(this.keyColumns);
    }

    public void setIdType(IdType idType) {
        this.keyColumns = EntityProviderMetaData.asKey(idType);
    }

    @JsonView(value={MetaDataCompatibilityVersion.Legacy25Dot1.class})
    public String getName() {
        return this.name;
    }

    @JsonView(value={MetaDataCompatibilityVersion.Legacy25Dot1.class})
    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this.labels);
    }

    @JsonView(value={MetaDataCompatibilityVersion.Legacy25Dot1.class})
    public List<PropertyMetaData> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyMetaData> properties) {
        this.properties = properties;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.keyColumns);
    }

    public String toString() {
        return "EntityTableMetaData [name=" + this.name + ", key=" + this.keyColumns + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EntityProviderMetaData other = (EntityProviderMetaData)((Object)obj);
        return this.name.equals(other.name) && Objects.equals(this.keyColumns, other.keyColumns);
    }

    private static List<KeyColumnDescriptor> asKey(IdType type) {
        return type != null ? Collections.singletonList(DefaultKeyColumnDescriptors.forIdType((IdType)type)) : null;
    }
}

