/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.pgx.api.Operation;
import oracle.pgx.common.MutableInteger;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.OperationType;

public class OperationImpl
implements Operation {
    private static final String EXPONENT_SYMBOL = "E";
    private static final String EXPONENT_MATCH = "E[0-9]+";
    private static final DecimalFormat DECIMAL_FORMATTER = new DecimalFormat("##0E0");
    private static final String[] DECIMAL_SUFFIX = new String[]{"", "k", "M", "G", "T", "P", "E", "Z", "Y"};
    private static final String ANCESTOR_PREFFIX = "|    ";
    private static final String ANCESTOR_IS_LAST_PREFFIX = "     ";
    private static final String ELEM_PREFIX = "+--- ";
    private static final String ELEM_IS_LAST_PREFFIX = "\\--- ";
    private static final int SPACES_BETWEEN_PIPE_AND_WHERE = 10;
    private static final int CHARACTERS_IN_WHERE = "WHERE ".length();
    private static final int INLINE_THRESHOLD = 2;
    private OperationType operationType;
    private String patternInfo;
    private double totalCostEstimate;
    private double cardinalityEstimate;
    private List<Operation> children;
    private PgxId graphId;
    private Set<String> filters = new HashSet<String>();

    public OperationImpl() {
        this.children = new ArrayList<Operation>();
        this.filters = new HashSet<String>();
    }

    public OperationImpl(PgxId graphId, OperationType operationType, String operationVarInfo, double totalCost, double cardinality) {
        this();
        this.graphId = graphId;
        this.operationType = operationType;
        this.patternInfo = operationVarInfo;
        this.totalCostEstimate = totalCost;
        this.cardinalityEstimate = cardinality;
    }

    public OperationImpl(PgxId graphId, OperationType operationType, String operationVarInfo, double totalCost, double cardinality, Set<String> filters) {
        this.graphId = graphId;
        this.operationType = operationType;
        this.patternInfo = operationVarInfo;
        this.totalCostEstimate = totalCost;
        this.cardinalityEstimate = cardinality;
        this.children = new ArrayList<Operation>();
        if (filters != null) {
            this.filters.addAll(filters);
        }
    }

    public OperationImpl(OperationType operationType, String operationVarInfo) {
        this.operationType = operationType;
        this.patternInfo = operationVarInfo;
        this.children = new ArrayList<Operation>();
        this.filters = new HashSet<String>();
    }

    @Override
    public PgxId getGraphId() {
        return this.graphId;
    }

    @Override
    public void print() {
        this.print(System.out);
    }

    @Override
    public void print(PrintStream printStream) {
        printStream.print(this.toString());
    }

    private void toString(StringBuilder treeStringBuilder, StringBuilder filterStringBuilder, boolean positionIsLast, List<Boolean> ancestorPostionsAreLast, Operation op, MutableInteger filterCounter) {
        for (boolean ancestorPostionIsLast : ancestorPostionsAreLast) {
            if (ancestorPostionIsLast) {
                treeStringBuilder.append(ANCESTOR_IS_LAST_PREFFIX);
                continue;
            }
            treeStringBuilder.append(ANCESTOR_PREFFIX);
        }
        if (positionIsLast) {
            treeStringBuilder.append(ELEM_IS_LAST_PREFFIX);
        } else {
            treeStringBuilder.append(ELEM_PREFIX);
        }
        boolean addPipe = false;
        if (!ancestorPostionsAreLast.isEmpty()) {
            addPipe = ancestorPostionsAreLast.get(ancestorPostionsAreLast.size() - 1) == false;
        }
        this.toString(op, treeStringBuilder, filterStringBuilder, filterCounter, addPipe);
        ArrayList<Boolean> newAncestorPostionsAreLast = new ArrayList<Boolean>(ancestorPostionsAreLast);
        newAncestorPostionsAreLast.add(positionIsLast);
        List<Operation> children = op.getChildren();
        if (!children.isEmpty() || newAncestorPostionsAreLast.contains(false)) {
            treeStringBuilder.append(System.lineSeparator());
        }
        for (int i = 0; i < children.size() - 1; ++i) {
            this.toString(treeStringBuilder, filterStringBuilder, false, newAncestorPostionsAreLast, children.get(i), filterCounter);
        }
        if (!children.isEmpty()) {
            this.toString(treeStringBuilder, filterStringBuilder, true, newAncestorPostionsAreLast, children.get(children.size() - 1), filterCounter);
        }
    }

    private void toString(Operation op, StringBuilder treeStringBuilder, StringBuilder filterStringBuilder, MutableInteger filterCounter, boolean addPipe) {
        if (op.getPatternInfo() != null) {
            treeStringBuilder.append(op.getPatternInfo() + " ");
        }
        treeStringBuilder.append(op.getOperationType());
        treeStringBuilder.append(" " + this.getEstimatesAsJson(op));
        int lastRowIndex = treeStringBuilder.lastIndexOf(System.lineSeparator());
        int firstParathesisIndex = treeStringBuilder.indexOf("(", lastRowIndex);
        int numberOfSpaces = firstParathesisIndex - lastRowIndex;
        if (op.getFilters().size() > 0) {
            treeStringBuilder.append(System.lineSeparator());
            if (addPipe) {
                this.addSpaces(treeStringBuilder, --numberOfSpaces - 10);
                treeStringBuilder.append('|');
                this.addSpaces(treeStringBuilder, 10);
            } else {
                this.addSpaces(treeStringBuilder, numberOfSpaces);
            }
            treeStringBuilder.append("WHERE ");
            int filterLines = op.getFilters().stream().map(x -> x.split(System.lineSeparator()).length).reduce(0, (y, z) -> y + z);
            if (filterLines > 2) {
                treeStringBuilder.append("$filter" + filterCounter.get());
                filterStringBuilder.append("filter" + filterCounter.getAndIncrement() + ": ");
                this.addFilters(filterStringBuilder, op.getFilters().iterator(), this.getFilterIndentation(filterCounter.get()), false);
                filterStringBuilder.append(System.lineSeparator());
            } else {
                this.addFilters(treeStringBuilder, op.getFilters().iterator(), numberOfSpaces + CHARACTERS_IN_WHERE, addPipe);
            }
        }
    }

    public int getFilterIndentation(int filterNumber) {
        if (filterNumber < 10) {
            return 9;
        }
        if (filterNumber < 100) {
            return 10;
        }
        return 9 + (int)Math.log10(filterNumber);
    }

    public void addSpaces(StringBuilder stringBuilder, int numberOfSpaces) {
        for (int i = 0; i < numberOfSpaces; ++i) {
            stringBuilder.append(' ');
        }
    }

    public void addFilters(StringBuilder stringBuilder, Iterator<String> it, int numberOfSpaces, boolean addPipe) {
        while (it.hasNext()) {
            String filter = it.next();
            String[] filterText = filter.split(System.lineSeparator());
            for (int i = 0; i < filterText.length; ++i) {
                stringBuilder.append(filterText[i]);
                if (i >= filterText.length - 1) continue;
                stringBuilder.append(System.lineSeparator());
                this.addSpaces(stringBuilder, numberOfSpaces);
            }
            if (!it.hasNext()) continue;
            stringBuilder.append(" AND");
            stringBuilder.append(System.lineSeparator());
            if (addPipe) {
                this.addSpaces(stringBuilder, numberOfSpaces - 10 - CHARACTERS_IN_WHERE);
                stringBuilder.append('|');
                this.addSpaces(stringBuilder, 10 + CHARACTERS_IN_WHERE);
                continue;
            }
            this.addSpaces(stringBuilder, numberOfSpaces);
        }
    }

    @Override
    public String getPatternInfo() {
        return this.patternInfo;
    }

    public String toString() {
        StringBuilder treeStringBuilder = new StringBuilder();
        StringBuilder filterStringBuilder = new StringBuilder();
        this.toString(treeStringBuilder, filterStringBuilder, true, Collections.EMPTY_LIST, this, new MutableInteger(1));
        if (filterStringBuilder.length() > 0) {
            treeStringBuilder.append(System.lineSeparator());
            treeStringBuilder.append((CharSequence)filterStringBuilder);
        }
        return treeStringBuilder.toString();
    }

    private static String prettyFormat(double number) {
        if (!Double.isFinite(number)) {
            return Double.toString(number);
        }
        String r = DECIMAL_FORMATTER.format(number);
        String exponent = r.substring(r.indexOf(EXPONENT_SYMBOL) + 1, r.length());
        int decimalSuffixIdx = Integer.parseInt(exponent) / 3;
        if (decimalSuffixIdx >= 0 && decimalSuffixIdx < DECIMAL_SUFFIX.length) {
            return r.replaceAll(EXPONENT_MATCH, DECIMAL_SUFFIX[decimalSuffixIdx]);
        }
        return r;
    }

    @Override
    public OperationType getOperationType() {
        return this.operationType;
    }

    @Override
    public double getCostEstimate() {
        double sumOfTotalCostChildren = this.children.stream().mapToDouble(Operation::getTotalCostEstimate).sum();
        return this.totalCostEstimate - sumOfTotalCostChildren;
    }

    @Override
    public double getTotalCostEstimate() {
        return this.totalCostEstimate;
    }

    @Override
    public double getCardinalityEstimate() {
        return this.cardinalityEstimate;
    }

    @Override
    public List<Operation> getChildren() {
        return this.children;
    }

    @Override
    public Set<String> getFilters() {
        return this.filters;
    }

    @Override
    public boolean isSameQueryPlan(Operation other) {
        if (this.getOperationType() != other.getOperationType()) {
            return false;
        }
        if (this.patternInfo != null && !this.getPatternInfo().equalsIgnoreCase(other.getPatternInfo())) {
            return false;
        }
        if (this.children.size() != other.getChildren().size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i).isSameQueryPlan(other.getChildren().get(i))) continue;
            return false;
        }
        return true;
    }

    public void addChild(Operation op) {
        this.children.add(op);
    }

    private String getEstimatesAsJson(Operation op) {
        return "{" + this.getFieldAsJson("cardinality", op.getCardinalityEstimate()) + ", " + this.getFieldAsJson("cost", op.getCostEstimate()) + ", " + this.getFieldAsJson("accumulatedCost", op.getTotalCostEstimate()) + "}";
    }

    private String getFieldAsJson(String key, double value) {
        return "\"" + key + "\":\"" + OperationImpl.prettyFormat(value) + "\"";
    }
}

