/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.compat;

import java.util.List;
import java.util.stream.Collectors;
import oracle.pgx.api.keys.ForeignKeyColumnDescriptor;
import oracle.pgx.api.keys.KeyColumnDescriptor;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.RdbmsEntityProviderConfig;
import oracle.pgx.config.RdbmsEntityProviderConfigBuilder;

public final class ConfigCompatibilityUtils {
    public static RdbmsEntityProviderConfigBuilder convertToConfigWithLegacyKeyDeclaration(RdbmsEntityProviderConfig providerConfig, boolean isVertexProvider) {
        List keyColumns = providerConfig.getValidatedKeyColumns();
        List sourceKeyColumns = providerConfig.getValidatedSourceKeyColumns();
        List destinationKeyColumns = providerConfig.getValidatedDestinationKeyColumns();
        IdType type = ((KeyColumnDescriptor)keyColumns.get(0)).getType();
        String keyColumnName = ((KeyColumnDescriptor)keyColumns.get(0)).getName();
        int keyColumnNbr = keyColumns.size();
        if (isVertexProvider) {
            if (keyColumnNbr == 1) {
                keyColumns.clear();
                RdbmsEntityProviderConfigBuilder providerConfigBuilder = new RdbmsEntityProviderConfigBuilder().copyFrom(providerConfig);
                providerConfigBuilder.setKeyType(type);
                providerConfigBuilder.setKeyColumn(keyColumnName);
                return providerConfigBuilder;
            }
            List keyColumnNames = keyColumns.stream().map(KeyColumnDescriptor::getName).collect(Collectors.toList());
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"COMPOSITE_VERTEX_KEY_UNSUPPORTED", (Object[])new Object[]{keyColumnNames.size(), providerConfig.getName(), keyColumnNames}));
        }
        ConfigCompatibilityUtils.throwOnCompositeSourceOrDestinationKey(providerConfig.getName(), true, sourceKeyColumns);
        ConfigCompatibilityUtils.throwOnCompositeSourceOrDestinationKey(providerConfig.getName(), false, destinationKeyColumns);
        String sourceKeyColumn = ((ForeignKeyColumnDescriptor)sourceKeyColumns.get(0)).getName();
        String destinationKeyColumn = ((ForeignKeyColumnDescriptor)destinationKeyColumns.get(0)).getName();
        sourceKeyColumns.clear();
        destinationKeyColumns.clear();
        keyColumns.clear();
        RdbmsEntityProviderConfigBuilder providerConfigBuilder = new RdbmsEntityProviderConfigBuilder().copyFrom(providerConfig);
        if (keyColumnNbr == 1) {
            providerConfigBuilder.setKeyType(type);
            providerConfigBuilder.setKeyColumn(keyColumnName);
        }
        providerConfigBuilder.setSourceColumn(sourceKeyColumn);
        providerConfigBuilder.setDestinationColumn(destinationKeyColumn);
        return providerConfigBuilder;
    }

    private static void throwOnCompositeSourceOrDestinationKey(String providerName, boolean isSource, List<? extends ForeignKeyColumnDescriptor> columnNames) {
        if (columnNames.size() > 1) {
            String message = isSource ? "COMPOSITE_SOURCE_VERTEX_KEY_UNSUPPORTED" : "COMPOSITE_DESTINATION_VERTEX_KEY_UNSUPPORTED";
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)message, (Object[])new Object[]{columnNames.size(), providerName, columnNames}));
        }
    }
}

