/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AnalysisTaskConfig;
import oracle.pgx.config.TaskPriority;

public final class AnalysisTaskConfigBuilder {
    private final Map<AnalysisTaskConfig.Field, Object> values = new HashMap<AnalysisTaskConfig.Field, Object>();

    public static AnalysisTaskConfig buildAnalysisTaskConfig(Consumer<AnalysisTaskConfigBuilder> builderSetup) {
        AnalysisTaskConfigBuilder builder = new AnalysisTaskConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public AnalysisTaskConfigBuilder() {
    }

    public AnalysisTaskConfigBuilder(Map<AnalysisTaskConfig.Field, Object> values) {
        this.putAll(values);
    }

    public AnalysisTaskConfigBuilder(AnalysisTaskConfig config) {
        this.putAll(config);
    }

    public AnalysisTaskConfigBuilder(AnalysisTaskConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public AnalysisTaskConfigBuilder putAll(Map<AnalysisTaskConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public AnalysisTaskConfigBuilder putAll(AnalysisTaskConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public AnalysisTaskConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public AnalysisTaskConfig build(String parentPath) {
        try {
            return AnalysisTaskConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public AnalysisTaskConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<AnalysisTaskConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "AnalysisTaskConfigBuilder" + this.values;
    }

    public AnalysisTaskConfigBuilder setWeight(int weight) {
        this.values.put(AnalysisTaskConfig.Field.WEIGHT, weight);
        return this;
    }

    public AnalysisTaskConfigBuilder setPriority(TaskPriority priority) {
        this.values.put(AnalysisTaskConfig.Field.PRIORITY, (Object)priority);
        return this;
    }

    public AnalysisTaskConfigBuilder setMaxThreads(int maxThreads) {
        this.values.put(AnalysisTaskConfig.Field.MAX_THREADS, maxThreads);
        return this;
    }
}

