/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PropertiesConfigParser;

public class EnterpriseSchedulerFlagsConfig
extends AbstractConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static EnterpriseSchedulerFlagsConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return EnterpriseSchedulerFlagsConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static EnterpriseSchedulerFlagsConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return EnterpriseSchedulerFlagsConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static EnterpriseSchedulerFlagsConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new EnterpriseSchedulerFlagsConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static EnterpriseSchedulerFlagsConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new EnterpriseSchedulerFlagsConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static EnterpriseSchedulerFlagsConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new EnterpriseSchedulerFlagsConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected EnterpriseSchedulerFlagsConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    public Boolean isShowLogging() {
        return (Boolean)this.values.get(Field.SHOW_LOGGING);
    }

    public Boolean isShowWarnings() {
        return (Boolean)this.values.get(Field.SHOW_WARNINGS);
    }

    public Boolean isShowEnvironment() {
        return (Boolean)this.values.get(Field.SHOW_ENVIRONMENT);
    }

    public Boolean isShowProfiling() {
        return (Boolean)this.values.get(Field.SHOW_PROFILING);
    }

    public Boolean isShowSchedulerState() {
        return (Boolean)this.values.get(Field.SHOW_SCHEDULER_STATE);
    }

    public Boolean isShowAllocations() {
        return (Boolean)this.values.get(Field.SHOW_ALLOCATIONS);
    }

    public Boolean isLogToStderr() {
        return (Boolean)this.values.get(Field.LOG_TO_STDERR);
    }

    public Boolean isShowDebug() {
        return (Boolean)this.values.get(Field.SHOW_DEBUG);
    }

    public Boolean useOpenmpThreadPool() {
        return (Boolean)this.values.get(Field.USE_OPENMP_THREAD_POOL);
    }

    public Integer getOverrideCoresPerSocket() {
        return (Integer)this.values.get(Field.OVERRIDE_CORES_PER_SOCKET);
    }

    public Boolean isOverrideMemoryPlacement() {
        return (Boolean)this.values.get(Field.OVERRIDE_MEMORY_PLACEMENT);
    }

    public String getMarkLoopForProfiling() {
        return (String)this.values.get(Field.MARK_LOOP_FOR_PROFILING);
    }

    public String getSelectPerformanceCounters() {
        return (String)this.values.get(Field.SELECT_PERFORMANCE_COUNTERS);
    }

    public String getSelectRegionPerformanceCounters() {
        return (String)this.values.get(Field.SELECT_REGION_PERFORMANCE_COUNTERS);
    }

    public Integer getSelectPerformanceCountersLibrary() {
        return (Integer)this.values.get(Field.SELECT_PERFORMANCE_COUNTERS_LIBRARY);
    }

    public Integer getSelectPerformanceCountersPcmShowCodes() {
        return (Integer)this.values.get(Field.SELECT_PERFORMANCE_COUNTERS_PCM_SHOW_CODES);
    }

    public Integer getSelectPerformanceCountersJobRegions() {
        return (Integer)this.values.get(Field.SELECT_PERFORMANCE_COUNTERS_JOB_REGIONS);
    }

    public Integer getSelectPerformanceCountersShowStats() {
        return (Integer)this.values.get(Field.SELECT_PERFORMANCE_COUNTERS_SHOW_STATS);
    }

    public Boolean isShowDeterministicOutput() {
        return (Boolean)this.values.get(Field.SHOW_DETERMINISTIC_OUTPUT);
    }

    public Boolean isSpinOnExit() {
        return (Boolean)this.values.get(Field.SPIN_ON_EXIT);
    }

    public Boolean isEnableDebugSignal() {
        return (Boolean)this.values.get(Field.ENABLE_DEBUG_SIGNAL);
    }

    public Boolean isFixThreadsUsedFromMain() {
        return (Boolean)this.values.get(Field.FIX_THREADS_USED_FROM_MAIN);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnterpriseSchedulerFlagsConfig other = (EnterpriseSchedulerFlagsConfig)obj;
        if (!Objects.equals(this.isShowLogging(), other.isShowLogging())) {
            return false;
        }
        if (!Objects.equals(this.isShowWarnings(), other.isShowWarnings())) {
            return false;
        }
        if (!Objects.equals(this.isShowEnvironment(), other.isShowEnvironment())) {
            return false;
        }
        if (!Objects.equals(this.isShowProfiling(), other.isShowProfiling())) {
            return false;
        }
        if (!Objects.equals(this.isShowSchedulerState(), other.isShowSchedulerState())) {
            return false;
        }
        if (!Objects.equals(this.isShowAllocations(), other.isShowAllocations())) {
            return false;
        }
        if (!Objects.equals(this.isLogToStderr(), other.isLogToStderr())) {
            return false;
        }
        if (!Objects.equals(this.isShowDebug(), other.isShowDebug())) {
            return false;
        }
        if (!Objects.equals(this.useOpenmpThreadPool(), other.useOpenmpThreadPool())) {
            return false;
        }
        if (!Objects.equals(this.getOverrideCoresPerSocket(), other.getOverrideCoresPerSocket())) {
            return false;
        }
        if (!Objects.equals(this.isOverrideMemoryPlacement(), other.isOverrideMemoryPlacement())) {
            return false;
        }
        if (!Objects.equals(this.getMarkLoopForProfiling(), other.getMarkLoopForProfiling())) {
            return false;
        }
        if (!Objects.equals(this.getSelectPerformanceCounters(), other.getSelectPerformanceCounters())) {
            return false;
        }
        if (!Objects.equals(this.getSelectRegionPerformanceCounters(), other.getSelectRegionPerformanceCounters())) {
            return false;
        }
        if (!Objects.equals(this.getSelectPerformanceCountersLibrary(), other.getSelectPerformanceCountersLibrary())) {
            return false;
        }
        if (!Objects.equals(this.getSelectPerformanceCountersPcmShowCodes(), other.getSelectPerformanceCountersPcmShowCodes())) {
            return false;
        }
        if (!Objects.equals(this.getSelectPerformanceCountersJobRegions(), other.getSelectPerformanceCountersJobRegions())) {
            return false;
        }
        if (!Objects.equals(this.getSelectPerformanceCountersShowStats(), other.getSelectPerformanceCountersShowStats())) {
            return false;
        }
        if (!Objects.equals(this.isShowDeterministicOutput(), other.isShowDeterministicOutput())) {
            return false;
        }
        if (!Objects.equals(this.isSpinOnExit(), other.isSpinOnExit())) {
            return false;
        }
        if (!Objects.equals(this.isEnableDebugSignal(), other.isEnableDebugSignal())) {
            return false;
        }
        return Objects.equals(this.isFixThreadsUsedFromMain(), other.isFixThreadsUsedFromMain());
    }

    public static enum Field implements ConfigField
    {
        SHOW_LOGGING(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        SHOW_WARNINGS(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        SHOW_ENVIRONMENT(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        SHOW_PROFILING(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        SHOW_SCHEDULER_STATE(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        SHOW_ALLOCATIONS(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        LOG_TO_STDERR(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        SHOW_DEBUG(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, null, false, false, false, false),
        USE_OPENMP_THREAD_POOL(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        OVERRIDE_CORES_PER_SOCKET(Collections.emptyList(), Collections.emptyList(), Integer.class, false, null, false, false, false, false),
        OVERRIDE_MEMORY_PLACEMENT(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, null, false, false, false, false),
        MARK_LOOP_FOR_PROFILING(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        SELECT_PERFORMANCE_COUNTERS(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        SELECT_REGION_PERFORMANCE_COUNTERS(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        SELECT_PERFORMANCE_COUNTERS_LIBRARY(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 0, false, false, false, false),
        SELECT_PERFORMANCE_COUNTERS_PCM_SHOW_CODES(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 0, false, false, false, false),
        SELECT_PERFORMANCE_COUNTERS_JOB_REGIONS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 0, false, false, false, false),
        SELECT_PERFORMANCE_COUNTERS_SHOW_STATS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 0, false, false, false, false),
        SHOW_DETERMINISTIC_OUTPUT(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, null, false, false, false, false),
        SPIN_ON_EXIT(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, null, false, false, false, false),
        ENABLE_DEBUG_SIGNAL(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, null, false, false, false, false),
        FIX_THREADS_USED_FROM_MAIN(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, null, false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("enterprise.scheduler.flags.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

