/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.jdbc;

import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.zone.ZoneRules;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import oracle.sql.TIMESTAMP;
import oracle.sql.ZONEIDMAP;

public class Util {
    private static final int SIZE_TIMESTAMPTZ = 13;
    private static int OFFSET_HOUR = 20;
    private static int MINUTE_SECOND = 60;
    private static int HOUR_SECOND = 3600;
    private static int OFFSET_MINUTE = 60;
    private static byte REGIONIDBIT = (byte)-128;

    static <T, E extends Throwable> T invokePgxApi(CheckedSupplier<T, E> supplier) throws SQLException {
        try {
            return supplier.supply();
        }
        catch (Throwable e) {
            Throwable cause = e;
            if (e.getClass() == ExecutionException.class || e.getClass() == CompletionException.class) {
                cause = e.getCause();
            } else if (e.getCause() != null && (e.getCause().getClass() == ExecutionException.class || e.getCause().getClass() == CompletionException.class)) {
                cause = e.getCause().getCause();
            }
            throw new SQLException(cause);
        }
    }

    private static int getOracleYear(int jYear) {
        return jYear <= 0 ? jYear - 1 : jYear;
    }

    private static int getHighOrderbits(int hour) {
        return (hour & 0x7F) << 6;
    }

    private static int getLowOrderbits(int minute) {
        return (minute & 0xFC) >> 2;
    }

    public static byte[] toBytes(OffsetDateTime odt) throws SQLException {
        if (odt == null) {
            return null;
        }
        byte[] result = new byte[13];
        OffsetDateTime odtutc = odt.withOffsetSameInstant(ZoneOffset.UTC);
        int year = Util.getOracleYear(odtutc.getYear());
        int month = odtutc.getMonthValue();
        int date = odtutc.getDayOfMonth();
        int hour = odtutc.getHour();
        int minute = odtutc.getMinute();
        int second = odtutc.getSecond();
        int nanos = odtutc.getNano();
        result[0] = (byte)(year / 100 + 100);
        result[1] = (byte)(year % 100 + 100);
        result[2] = (byte)month;
        result[3] = (byte)date;
        result[4] = (byte)(hour + 1);
        result[5] = (byte)(minute + 1);
        result[6] = (byte)(second + 1);
        result[7] = (byte)(nanos >> 24);
        result[8] = (byte)(nanos >> 16 & 0xFF);
        result[9] = (byte)(nanos >> 8 & 0xFF);
        result[10] = (byte)(nanos & 0xFF);
        int offset = odt.getOffset().getTotalSeconds();
        result[11] = (byte)(offset / HOUR_SECOND + OFFSET_HOUR);
        result[12] = (byte)(offset % HOUR_SECOND / MINUTE_SECOND + OFFSET_MINUTE);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OffsetDateTime toOffsetDateTime(byte[] timestamptz) throws SQLException {
        int[] result = new int[13];
        for (int i = 0; i < 13; ++i) {
            result[i] = timestamptz[i] & 0xFF;
        }
        int year = TIMESTAMP.getJavaYear((int)result[0], (int)result[1]);
        int nanos = TIMESTAMP.getNanos((byte[])timestamptz, (int)7);
        OffsetDateTime odtUTC = OffsetDateTime.of(year, result[2], result[3], result[4] - 1, result[5] - 1, result[6] - 1, nanos, ZoneOffset.UTC);
        ZoneOffset zOffset = null;
        if ((result[11] & REGIONIDBIT) != 0) {
            int regionID = Util.getHighOrderbits(result[11]);
            String tzName = ZONEIDMAP.getRegion((int)(regionID += Util.getLowOrderbits(result[12])));
            ZoneId tzid = ZoneId.of(tzName);
            ZoneRules zRule = tzid.getRules();
            if (!zRule.isFixedOffset()) throw new SQLException("Timezone not supported: " + tzName);
            zOffset = zRule.getOffset(odtUTC.toInstant());
            return odtUTC.withOffsetSameInstant(zOffset);
        } else {
            int off_hour = result[11] - OFFSET_HOUR;
            int off_minute = result[12] - OFFSET_MINUTE;
            zOffset = ZoneOffset.ofHoursMinutes(off_hour, off_minute);
        }
        return odtUTC.withOffsetSameInstant(zOffset);
    }

    static interface CheckedSupplier<T, E extends Throwable> {
        public T supply() throws E;
    }

    static interface CheckedFunction<P, T, E extends Throwable> {
        public T apply(P var1) throws E;
    }
}

