/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.sqlpgq;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import oracle.datastudio.graphviz.formatter.DataStudioFormatter;
import oracle.datastudio.graphviz.gvt.GvtFormatter;
import oracle.datastudio.graphviz.gvt.json.ResultGraph;
import oracle.jdbc.OracleCallableStatement;
import oracle.pg.rdbms.RdbmsDriver;
import oracle.pg.rdbms.sqlpgq.SqlCursorWrapper;
import oracle.pg.rdbms.sqlpgq.SqlPgqEnhancedResultSet;
import oracle.pg.rdbms.sqlpgq.SqlPgqMetadataUtils;
import oracle.pg.rdbms.sqlpgq.SqlPgqResultSetTable;
import oracle.pg.rdbms.sqlpgq.exception.SqlPgqVisualizationException;
import oracle.pgql.lang.PgqlException;
import oracle.pgx.graphviz.driver.CursorWrapper;
import oracle.pgx.graphviz.driver.GraphInformation;
import oracle.pgx.graphviz.driver.GraphName;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Result;
import oracle.pgx.graphviz.formatter.ResultType;
import oracle.pgx.graphviz.formatter.Table;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlPgqDriver
extends RdbmsDriver {
    private static final Logger LOG = LoggerFactory.getLogger(SqlPgqDriver.class);
    private static final String DATASTUDIO_CLASS_NAME = DataStudioFormatter.class.getName();
    private static final String GVT_CLASS_NAME = GvtFormatter.class.getName();
    private static String getMetadataFunction;
    public static int ORA_CODE_NON_VISUALIZABLE_RESULT;
    public static int ORA_CODE_FUNCTION_NOT_INSTALLED;
    public static int ORA_CODE_NO_DATA_FOUND;
    private static String SQL_FUNCTION_ERROR_MESSAGE;
    private static String SQL_FUNCTION_ERROR_MESSAGE_2;
    private static String SQL_FUNCTION_ERROR_MESSAGE_3;
    public static final String EXECUTION_SUCCESS_MESSAGE = "The statement was executed successfully. No rows returned.";
    public static final String ONE_ROW_PER_STEP__ERROR_MESSAGE = "Visualizing queries that use ONE ROW PER clause cannot use graphs with aliases for vertex or edge tables. Please create a graph without aliases for vertex or edge tables and re-try your query.";
    private static final String OPEN_CURSOR_QUERY = "DECLARE c SYS_REFCURSOR; BEGIN OPEN c FOR ?; ?:= DBMS_SQL.TO_CURSOR_NUMBER(c); END;";
    private static String visualizeQuery;
    private static ObjectMapper mapper;

    public SqlPgqDriver(Map<String, Object> properties) throws SQLException, IOException {
        super(properties);
        visualizeQuery = this.readFunction("/cust_sqlgraph_json.sql") + " BEGIN ? := ORA_SQLGRAPH_TO_JSON(?, ?, ?); END;";
        getMetadataFunction = this.readFunction("/get_graph_metadata.sql");
    }

    private String readFunction(String functionName) throws IOException {
        return IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(functionName), (Charset)StandardCharsets.UTF_8);
    }

    public EnhancedResultSet query(@Nonnull String query, String graphName, @Nullable String schema, Map<String, Object> properties) throws PgqlException, SQLException {
        throw new UnsupportedOperationException();
    }

    public String modify(@Nonnull String pgqlQuery, String graphName, Map<String, Object> properties) throws PgqlException, SQLException {
        throw new UnsupportedOperationException();
    }

    public Collection<GraphName> getGraphs(Map<String, Object> properties) throws SQLException {
        DataSource ods = (DataSource)properties.get("datasource");
        try (Connection conn = ods.getConnection();){
            Set<GraphName> graphs;
            Set<GraphName> set = graphs = SqlPgqMetadataUtils.getGraphNames(conn);
            return set;
        }
    }

    public Map getGraphSchema(String graphOwner, String graphName, Map<String, Object> properties) throws SQLException {
        String result = "";
        DataSource ods = (DataSource)properties.get("datasource");
        try (Connection conn = ods.getConnection();){
            String finalQuery = getMetadataFunction + " SELECT get_graph_metadata(?, ?) AS RESULT FROM SYS.DUAL";
            try (PreparedStatement preparedStatement = conn.prepareStatement(finalQuery);){
                preparedStatement.setString(1, graphOwner);
                preparedStatement.setString(2, graphName);
                ResultSet rs = preparedStatement.executeQuery();
                if (rs.next()) {
                    result = rs.getString("RESULT");
                    LOG.info("Result from the database: {}", (Object)result);
                }
            }
        }
        Map resultMap = new HashMap();
        try {
            resultMap = (Map)mapper.readValue(result, Map.class);
        }
        catch (JsonProcessingException e) {
            LOG.info("Error during graphs schema mapping", (Throwable)e);
            throw new IllegalArgumentException("JSON Schema returned by the database was invalid.");
        }
        LOG.info("Mapped result {}", resultMap);
        return resultMap;
    }

    @Nonnull
    public GraphInformation getGraph(@Nullable String schemaName, @Nonnull String name, Map<String, Object> properties) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isDirectedSupported() {
        throw new UnsupportedOperationException();
    }

    public boolean supportsMultipleIterations() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    private String constructTable(Connection conn, String query, int start, int size) throws SQLException {
        ArrayList<String> header = new ArrayList<String>();
        try (PreparedStatement preparedStatement = conn.prepareStatement(query);){
            Object object;
            ResultSet rs = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            int count = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                String columnName = resultSetMetaData.getColumnName(i);
                header.add(columnName);
            }
            SqlPgqResultSetTable table = new SqlPgqResultSetTable(rs, header);
            if (table.getHeader().size() > 0) {
                object = String.join((CharSequence)"\t", table.getHeader()) + "\n" + StreamSupport.stream(table.getRows().spliterator(), false).skip(start).limit(size).map(cells -> cells.stream().map(DataStudioFormatter::toStringValue).collect(Collectors.joining("\t"))).collect(Collectors.joining("\n"));
                return object;
            }
            object = "";
            return object;
        }
    }

    private Optional<Result> constructFullJson(String graph, String table, String schema, String graphName) throws JsonProcessingException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ResultGraph resultGraph = (ResultGraph)mapper.readValue(graph, ResultGraph.class);
        ret.put("graph", resultGraph);
        ret.put("name", graphName);
        ret.put("schema", schema);
        ret.put("resultSetId", UUID.randomUUID().toString());
        ret.put("table", table);
        String json = mapper.writeValueAsString(ret);
        LOG.debug("Result as JSON: {}", (Object)json);
        return Optional.of(new Result(ResultType.NETWORK, json));
    }

    private Optional<Result> constructTableJson(String table, String schema, String graphName) throws JsonProcessingException {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("table", table);
        String json = mapper.writeValueAsString(ret);
        return Optional.of(new Result(ResultType.TABLE, json));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Result> execute(String query, @Nullable String schema, String graphName, Map<String, Object> properties) {
        DataSource ods = (DataSource)properties.get("datasource");
        try (Connection conn = ods.getConnection();){
            OracleCallableStatement cs;
            block27: {
                if (schema == null) {
                    schema = conn.getSchema();
                }
                String formatterClass = (String)properties.getOrDefault("graphviz.formatter.class", GVT_CLASS_NAME);
                int size = Integer.parseInt(properties.getOrDefault("size", 100).toString());
                int start = Integer.parseInt(properties.getOrDefault("start", 0).toString());
                if (formatterClass.equals(DATASTUDIO_CLASS_NAME)) {
                    SqlPgqEnhancedResultSet resultSet = new SqlPgqEnhancedResultSet(query, conn, properties);
                    DataStudioFormatter formatter = new DataStudioFormatter();
                    Optional<Result> optional = Optional.of(formatter.format((EnhancedResultSet)resultSet, properties));
                    return optional;
                }
                if (!formatterClass.equals(GVT_CLASS_NAME)) throw new IllegalArgumentException("The formatter specified does not exist");
                String table = null;
                table = this.constructTable(conn, query, start, size);
                if (table != null && table.isEmpty()) {
                    Optional<Result> formatter = Optional.of(new Result(ResultType.TEXT, EXECUTION_SUCCESS_MESSAGE));
                    return formatter;
                }
                Integer cursorId = this.openCursor(query, conn);
                try {
                    Optional<Result> optional;
                    cs = (OracleCallableStatement)conn.prepareCall(visualizeQuery);
                    try {
                        cs.registerOutParameter(1, 2005);
                        cs.setLong(2, (long)cursorId.intValue());
                        cs.setInt(3, start);
                        if (size == Integer.MAX_VALUE) {
                            cs.setNull(4, 4);
                        } else {
                            cs.setInt(4, size);
                        }
                        cs.execute();
                        String graphResult = cs.getString(1);
                        if (graphResult == null) break block27;
                        LOG.debug("Result from function {}", (Object)graphResult);
                        optional = this.constructFullJson(graphResult, table, schema, graphName);
                        if (cs == null) return optional;
                    }
                    catch (Throwable graphResult) {
                        if (cs == null) throw graphResult;
                        try {
                            cs.close();
                            throw graphResult;
                        }
                        catch (Throwable throwable) {
                            graphResult.addSuppressed(throwable);
                        }
                        throw graphResult;
                    }
                    cs.close();
                    return optional;
                }
                catch (SQLException e) {
                    int oraCode = e.getErrorCode();
                    if (oraCode == ORA_CODE_NON_VISUALIZABLE_RESULT) {
                        if (!e.getMessage().contains(SQL_FUNCTION_ERROR_MESSAGE) && !e.getMessage().contains(SQL_FUNCTION_ERROR_MESSAGE_2)) {
                            if (!e.getMessage().contains(SQL_FUNCTION_ERROR_MESSAGE_3)) throw e;
                        }
                        Optional<Result> optional = this.constructTableJson(table, schema, graphName);
                        if (conn == null) return optional;
                        conn.close();
                        return optional;
                    }
                    if (oraCode == ORA_CODE_FUNCTION_NOT_INSTALLED) {
                        throw new IllegalArgumentException("This feature is only supported on Oracle Database version 23.4 or newer");
                    }
                    if (oraCode != ORA_CODE_NO_DATA_FOUND) throw e;
                    if (!StringUtils.containsIgnoreCase((CharSequence)query, (CharSequence)"ONE ROW PER")) throw new IllegalStateException("The result is empty.");
                    throw new IllegalStateException(ONE_ROW_PER_STEP__ERROR_MESSAGE);
                }
            }
            if (cs == null) throw new IllegalArgumentException("The formatter specified does not exist");
            cs.close();
            throw new IllegalArgumentException("The formatter specified does not exist");
        }
        catch (IOException | SQLException ex) {
            throw new SqlPgqVisualizationException(ex);
        }
    }

    public Future<Optional<Result>> executeAsync(String query, String schema, String graphName, Map<String, Object> properties) {
        CompletableFuture<Optional<Result>> queryExecution = CompletableFuture.supplyAsync(() -> this.execute(query, schema, graphName, properties));
        return queryExecution;
    }

    public Future<CursorWrapper> createCursorWrapperAsync(String connectionId, String query, Map<String, Object> properties) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.createCursorWrapper(connectionId, query, properties);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }).exceptionally(ex -> {
            LOG.debug(ex.getMessage());
            return null;
        });
    }

    public CursorWrapper createCursorWrapper(String connectionId, String query, Map<String, Object> properties) throws SQLException {
        DataSource ds = (DataSource)properties.get("datasource");
        Connection connection = ds.getConnection();
        SqlCursorWrapper cursorWrapper = null;
        try {
            cursorWrapper = new SqlCursorWrapper(connectionId, connection);
            Table table = this.getResultTable(query, connection);
            cursorWrapper.setResultTable(table);
            if (table.getHeader().size() > 0) {
                Integer cursorId = this.openCursor(query, connection);
                cursorWrapper.setCursorId(cursorId);
                if (StringUtils.containsIgnoreCase((CharSequence)query, (CharSequence)"ONE ROW PER")) {
                    cursorWrapper.setHasOneRowPerStep(true);
                }
            }
            return cursorWrapper;
        }
        catch (IOException | SQLException ex) {
            if (cursorWrapper != null) {
                cursorWrapper.close();
            }
            throw new SqlPgqVisualizationException(ex);
        }
    }

    private Integer openCursor(String query, Connection connection) throws SQLException {
        OracleCallableStatement cs = (OracleCallableStatement)connection.prepareCall(OPEN_CURSOR_QUERY);
        cs.setString(1, query);
        cs.registerOutParameter(2, 2);
        cs.execute();
        Integer cursorId = cs.getInt(2);
        return cursorId;
    }

    private Table getResultTable(String query, Connection connection) throws SQLException {
        ArrayList<String> header = new ArrayList<String>();
        PreparedStatement preparedStatement = connection.prepareStatement(query);
        ResultSet rs = preparedStatement.executeQuery();
        ResultSetMetaData resultSetMetaData = rs.getMetaData();
        int count = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String columnName = resultSetMetaData.getColumnName(i);
            header.add(columnName);
        }
        SqlPgqResultSetTable table = new SqlPgqResultSetTable(rs, header);
        return table;
    }

    static {
        ORA_CODE_NON_VISUALIZABLE_RESULT = 20000;
        ORA_CODE_FUNCTION_NOT_INSTALLED = 6553;
        ORA_CODE_NO_DATA_FOUND = 1403;
        SQL_FUNCTION_ERROR_MESSAGE = "Please add vertex_id/edge_id in CLOUMNS clause";
        SQL_FUNCTION_ERROR_MESSAGE_2 = "Please add vertex_id/edge_id in both the COLUMNS and SELECT clause";
        SQL_FUNCTION_ERROR_MESSAGE_3 = "Please add vertex_id/edge_id to the COLUMNS clause and project the corresponding column name in the SELECT clause";
        mapper = new ObjectMapper();
    }
}

