/*
 * Decompiled with CFR 0.152.
 */
package oracle.datastudio.graphviz.formatter.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMultiset;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.datastudio.graphviz.ResultGraphCreator;
import oracle.datastudio.graphviz.formatter.json.Edge;
import oracle.datastudio.graphviz.formatter.json.Path;
import oracle.datastudio.graphviz.formatter.json.Property;
import oracle.datastudio.graphviz.formatter.json.Vertex;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Graph;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ResultGraph
implements ResultGraphCreator {
    @JsonProperty(value="idType")
    public String idType;
    @JsonProperty(value="vertices")
    public List<Vertex> vertices;
    @JsonProperty(value="edges")
    public List<Edge> edges;
    @JsonProperty(value="paths")
    public Set<Path> path;
    @JsonProperty(value="totalNumResults")
    public long totalNumResults;
    @JsonProperty(value="graphOwner")
    public String graphOwner;
    @JsonProperty(value="graphName")
    public String graphName;

    public ResultGraph() {
    }

    private ResultGraph(@Nonnull List<Vertex> vertices, @Nonnull List<Edge> edges, @Nonnull Set<Path> path, long totalNumResults, String graphOwner, String graphName) {
        this.idType = vertices.size() > 0 && vertices.get((int)0).id instanceof String ? "string" : "number";
        this.vertices = vertices;
        this.edges = edges;
        this.path = path;
        this.totalNumResults = totalNumResults;
        this.graphOwner = graphOwner;
        this.graphName = graphName;
    }

    @Nullable
    public ResultGraph fromEnhancedResultSet(@Nonnull EnhancedResultSet enhancedResultSet, int start, int size, String graphOwner, String graphName) {
        return ResultGraph.staticfromEnhancedResultSet(enhancedResultSet, start, size, graphOwner, graphName);
    }

    @Nullable
    public static ResultGraph staticfromEnhancedResultSet(@Nonnull EnhancedResultSet enhancedResultSet, int start, int size, String graphOwner, String graphName) {
        Graph graph = enhancedResultSet.createGraphRepresentation(start, size);
        if (graph != null) {
            List<Vertex> vertices = graph.getVertices().stream().map(ResultGraph::mapVertex).collect(Collectors.toList());
            List<Edge> edges = graph.getEdges().stream().map(ResultGraph::mapEdge).collect(Collectors.toList());
            Set<Path> paths = graph.getPaths().stream().map(ResultGraph::mapPath).collect(Collectors.toSet());
            return new ResultGraph(vertices, edges, paths, enhancedResultSet.getNumResults(), graphOwner, graphName);
        }
        return null;
    }

    @Nonnull
    private static Path mapPath(@Nonnull oracle.pgx.graphviz.formatter.Path path) {
        return new Path(path.getSrc(), path.getDest());
    }

    @Nonnull
    private static Edge mapEdge(@Nonnull oracle.pgx.graphviz.formatter.Edge edge) {
        Edge ret = new Edge(edge.getId(), edge.getSourceId(), edge.getDestId(), edge.isUndirected(), new HashSet<String>(edge.getLabels()), edge.getProperties().stream().map(ResultGraph::mapProperty).collect(Collectors.toList()));
        edge.getGroups().forEach(ret::addGroup);
        return ret;
    }

    @Nonnull
    private static Vertex mapVertex(@Nonnull oracle.pgx.graphviz.formatter.Vertex vertex) {
        Vertex ret = new Vertex(vertex.getId(), new HashSet<String>(vertex.getLabels()), vertex.getProperties().stream().map(ResultGraph::mapProperty).collect(Collectors.toList()));
        vertex.getGroups().forEach(ret::addGroup);
        return ret;
    }

    @Nonnull
    private static Property mapProperty(@Nonnull oracle.pgx.graphviz.formatter.Property property) {
        return new Property(property.getName(), property.getValue(), property.isSelected());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultGraph that = (ResultGraph)o;
        return this.idType.equals(that.idType) && ImmutableMultiset.copyOf(this.vertices).equals((Object)ImmutableMultiset.copyOf(that.vertices)) && ImmutableMultiset.copyOf(this.edges).equals((Object)ImmutableMultiset.copyOf(that.edges)) && Objects.equals(this.path, that.path) && this.totalNumResults == that.totalNumResults;
    }

    public int hashCode() {
        return Objects.hash(this.idType, ImmutableMultiset.copyOf(this.vertices), ImmutableMultiset.copyOf(this.edges), this.path, this.totalNumResults);
    }
}

