/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library;

import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultSet;
import oracle.pgx.graphviz.formatter.Graph;
import oracle.pgx.graphviz.library.TableOnlyResultSet;
import oracle.pgx.graphviz.library.enhancer.Enhancement;
import oracle.pgx.graphviz.library.graph.GraphBuilder;

public class VisualResultSet
extends TableOnlyResultSet {
    @Nonnull
    private final Enhancement enhancement;
    private final boolean isDirectedFunctionSupported;

    public VisualResultSet(@Nonnull ResultSet resultSet, @Nonnull Enhancement enhancement, @Nullable String schema, @Nonnull List<String> header, boolean isDirectedFunctionSupported, boolean supportsMultipleIterations) throws PgqlException {
        super(resultSet, enhancement.getQuery().getGraphName().getName(), schema, header, supportsMultipleIterations);
        this.enhancement = enhancement;
        this.isDirectedFunctionSupported = isDirectedFunctionSupported;
    }

    @Override
    @Nonnull
    public Graph createGraphRepresentation(int start, int size) {
        try {
            return new GraphBuilder(this.resultSet, this.enhancement, start, size, this.isDirectedFunctionSupported).buildGraph();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public Graph createGraphRepresentation() {
        return this.createGraphRepresentation(0, this.numResults);
    }

    @Override
    public boolean hasGraph() {
        return true;
    }
}

