/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.io.IOException;
import java.math.BigDecimal;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.tree.JakartaPrimitive;
import oracle.jdbc.driver.json.tree.JsonpPrimitive;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.sql.NUMBER;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonStringNumberImpl
extends OracleJsonNumberImpl
implements OracleJsonDecimal {
    String value;

    public OracleJsonStringNumberImpl(String value) {
        this.value = value;
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.DECIMAL;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof OracleJsonDecimal)) {
            return false;
        }
        OracleJsonDecimal othern = (OracleJsonDecimal)other;
        return this.bigDecimalValue().equals(othern.bigDecimalValue());
    }

    @Override
    public int hashCode() {
        return this.bigDecimalValue().hashCode();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.value);
    }

    public void serialize(Appendable out) {
        try {
            out.append(this.value);
        }
        catch (IOException e) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e, new Object[0]);
        }
    }

    @Override
    public NUMBER getNUMBER() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T wrap(Class<T> c) {
        if (Jsonp.isJakartaJson(c)) {
            return c.cast(new JakartaPrimitive.JakartaStringNumberImpl(this.value));
        }
        return c.cast(new JsonpPrimitive.JsonpStringNumberImpl(this.value));
    }

    @Override
    public OracleJsonDecimal.TargetType getTargetType() {
        return null;
    }
}

