/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.List;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.ExecutionInfo;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.pgview.PgViewModifyTrans;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgViewDmlExecution {
    private static final Logger ms_log = LoggerFactory.getLogger(PgViewDmlExecution.class);
    private final Connection conn;
    private final ExecutionInfo executionInfo;
    private boolean usePtt;
    private int[] cntBindVarIdx;
    private int totalStatements;
    private String gttTableName;

    public PgViewDmlExecution(Connection conn, ExecutionInfo executionInfo) {
        this.conn = conn;
        this.executionInfo = executionInfo;
    }

    public void prepareModify(PgViewModifyTrans modifyTrans, int parallel, int dynamicSampling, boolean append) throws SQLException {
        String stmt;
        ms_log.debug("Preparing modify");
        this.usePtt = modifyTrans.getPatternTranslation() != null;
        String hint = DbmsUtils.buildHint(parallel, dynamicSampling, append, false);
        this.totalStatements = 0;
        if (this.usePtt) {
            this.totalStatements = 3;
        }
        this.totalStatements += modifyTrans.getModifications().stream().mapToInt(List::size).sum();
        this.executionInfo.currentStmts = new Statement[this.totalStatements];
        this.cntBindVarIdx = new int[this.totalStatements];
        int idxStatement = 0;
        if (this.usePtt) {
            this.gttTableName = modifyTrans.getGttTableName();
            for (Pair pair : modifyTrans.getPatternTranslation()) {
                String hintPtt = hint;
                int parallelPtt = DbmsUtils.getParallelSafeValueForPTT(parallel, (List)pair.second);
                if (parallelPtt != parallel) {
                    hintPtt = DbmsUtils.buildHint(parallelPtt, dynamicSampling, append, false);
                }
                if (this.gttTableName.startsWith("ORA$GTT_")) {
                    hintPtt = DbmsUtils.buildHint(parallelPtt, dynamicSampling, false, false);
                }
                stmt = this.replaceHint((String)pair.first, hintPtt);
                this.prepareStatement(stmt, idxStatement++);
            }
        }
        for (List list : modifyTrans.getModifications()) {
            for (Pair modify : list) {
                stmt = this.replaceHint((String)modify.first, hint);
                List bindValues = (List)modify.second;
                this.cntBindVarIdx[idxStatement] = bindValues == null ? 1 : bindValues.size() + 1;
                this.prepareCall(stmt, idxStatement++);
            }
        }
        if (this.usePtt) {
            String stmt2 = (String)modifyTrans.getDropTranslation().first;
            this.prepareStatement(stmt2, idxStatement);
        }
    }

    public void executeModify(boolean autoCommit) throws SQLException {
        Savepoint savepoint = null;
        long modifyCount = 0L;
        try {
            PreparedStatement ps;
            int idxStatement;
            if (autoCommit) {
                savepoint = this.conn.setSavepoint();
            }
            int finalIdx = this.totalStatements;
            if (this.usePtt) {
                for (idxStatement = 0; idxStatement < 2; ++idxStatement) {
                    ms_log.debug("Executing statement at idx " + idxStatement);
                    ps = (PreparedStatement)this.executionInfo.currentStmts[idxStatement];
                    ps.execute();
                }
                --finalIdx;
            }
            while (idxStatement < finalIdx) {
                ms_log.debug("Executing statement at idx " + idxStatement);
                CallableStatement cs = (CallableStatement)this.executionInfo.currentStmts[idxStatement];
                int countIdx = this.cntBindVarIdx[idxStatement];
                cs.registerOutParameter(countIdx, 4);
                cs.execute();
                modifyCount += (long)cs.getInt(countIdx);
                ++idxStatement;
            }
            this.executionInfo.modifyCount = modifyCount;
            if (this.usePtt) {
                ms_log.debug("Executing statement at idx " + idxStatement);
                ps = (PreparedStatement)this.executionInfo.currentStmts[idxStatement];
                ps.execute();
            }
            if (autoCommit) {
                this.conn.commit();
            }
        }
        catch (Exception ex) {
            ms_log.debug("Error while updating: " + ex.getMessage());
            if (this.usePtt) {
                String drop = "DROP TABLE " + this.gttTableName;
                ms_log.debug("Executing:[" + drop + "]");
                try (PreparedStatement ps = this.conn.prepareStatement(drop);){
                    ps.execute();
                }
                catch (Exception e) {
                    ms_log.debug("Error while dropping GTT/PTT:" + e.getMessage());
                }
            }
            if (autoCommit && savepoint != null) {
                this.conn.rollback(savepoint);
            }
            throw ex;
        }
    }

    private String replaceHint(String stmt, String hint) {
        if ("".equals(hint)) {
            return stmt.replaceFirst("/\\*\\+ \\*/ ", "");
        }
        return stmt.replaceFirst("/\\*\\+ ", "/*+ " + hint);
    }

    private void prepareStatement(String str, int idx) throws SQLException {
        if (this.executionInfo.isCanceled) {
            throw new PgqlToSqlException("User requested cancel of current operation");
        }
        ms_log.debug("Preparing statement [" + str + "] at idx " + idx);
        this.executionInfo.currentStmts[idx] = this.conn.prepareStatement(str);
    }

    private void prepareCall(String str, int idx) throws SQLException {
        if (this.executionInfo.isCanceled) {
            throw new PgqlToSqlException("User requested cancel of current operation");
        }
        ms_log.debug("Preparing call [" + str + "] at idx " + idx);
        this.executionInfo.currentStmts[idx] = this.conn.prepareCall(str);
    }
}

