/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.pgview.translation.expression.InsertionBlock;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableExpression;

public class ElementInsertion
extends TableExpression {
    private final String variableName;
    private final String tableName;
    private final List<String> key;
    private final List<String> columns;
    private final List<String> values;
    private final List<Integer> srcOrDstCols;
    private final List<String> srcOrDstVertexNames;
    private String combineCheck;
    private boolean isDuplicate;

    public ElementInsertion(String variableName, String tableName, List<String> key) {
        this.variableName = variableName;
        this.tableName = tableName;
        this.key = key;
        this.columns = new ArrayList<String>();
        this.values = new ArrayList<String>();
        this.srcOrDstCols = new ArrayList<Integer>();
        this.srcOrDstVertexNames = new ArrayList<String>();
        this.combineCheck = "";
        this.isDuplicate = false;
    }

    public void addValue(String value, String column, boolean isSrcOrDstKey, String vertexName) {
        this.values.add(value);
        this.columns.add(column);
        if (isSrcOrDstKey) {
            this.srcOrDstCols.add(this.columns.size() - 1);
            this.srcOrDstVertexNames.add(vertexName);
        }
    }

    public void addVariablesToBlock(InsertionBlock insertionBlock) {
        this.key.forEach(keyColumn -> insertionBlock.addVariable(PgqlUtils.escapeAndEnquoteIdentifier(this.variableName + "_" + keyColumn), this.tableName, PgqlUtils.escapeAndEnquoteIdentifier(keyColumn), false));
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setDuplicate() {
        this.isDuplicate = true;
    }

    public void combine(ElementInsertion elementInsertion) {
        int numCols = elementInsertion.columns.size();
        int thisColumns = this.columns.size();
        for (int i = 0; i < numCols; ++i) {
            String column = elementInsertion.columns.get(i);
            String value = elementInsertion.values.get(i);
            boolean isCommon = false;
            for (int j = 0; j < thisColumns; ++j) {
                if (!this.columns.get(j).equals(column)) continue;
                isCommon = true;
                this.combineCheck = this.combineCheck + this.buildValueCheck(this.values.get(j), value, column, elementInsertion.getVariableName(), column, false);
            }
            if (isCommon) continue;
            this.columns.add(column);
            this.values.add(value);
        }
    }

    private String getSrcOrDstKeyCheck() {
        String check = "";
        for (int j = this.srcOrDstCols.size() - 1; j >= 0; --j) {
            int idx = this.srcOrDstCols.get(j);
            String column = this.columns.get(idx);
            for (int i = 0; i < idx; ++i) {
                if (!column.equals(this.columns.get(i))) continue;
                String value1 = this.values.get(i);
                String vertexKey = this.values.get(idx);
                String vertexName = this.srcOrDstVertexNames.get(j);
                String vertexKeyColumn = vertexKey.replaceFirst(vertexName + "_", "");
                check = check + this.buildValueCheck(value1, vertexKey, column, vertexName, vertexKeyColumn, true);
                this.columns.remove(idx);
                this.values.remove(idx);
            }
        }
        return check;
    }

    private String buildValueCheck(String value1, String value2, String column1, String vertexName, String column2, boolean isKey) {
        return "    BEGIN\n      if " + value1 + " <> " + value2 + " then\n        " + this.getErrorMessage(value1, value2, column1, vertexName, column2, isKey) + "      end if;\n     EXCEPTION when others then\n      if SQLCODE != -6502 then\n        raise;\n      else\n        " + this.getErrorMessage(value1, value2, column1, vertexName, column2, isKey) + "      end if;\n    END;\n";
    }

    private String getErrorMessage(String value1, String vertexKey, String column, String vertexName, String vertexColumn, boolean isKey) {
        String propMsg = isKey ? " references vertex key " : " is the same as ";
        return "raise_application_error(-20000, " + DbmsUtils.escapeAndEnquoteLiteral("Cannot insert edge " + this.variableName + " because property " + this.variableName + "." + column + propMsg + "property " + vertexName + "." + vertexColumn + " but its value " + value1 + " is not the same as value ", false) + " || " + vertexKey + " || " + DbmsUtils.escapeAndEnquoteLiteral(" defined in insertion of vertex " + vertexName, false) + ");\n";
    }

    @Override
    public String prettyPrint() {
        if (this.isDuplicate) {
            return "";
        }
        String keyCols = this.key.stream().map(PgqlUtils::escapeAndEnquoteIdentifier).collect(Collectors.joining(", "));
        List keyVars = this.key.stream().map(keyColumn -> PgqlUtils.escapeAndEnquoteIdentifier(this.variableName + "_" + keyColumn)).collect(Collectors.toList());
        String nullCheck = keyVars.stream().map(keyVar -> keyVar + " IS NULL ").collect(Collectors.joining(" or "));
        String srcOrDstCheck = this.getSrcOrDstKeyCheck();
        return srcOrDstCheck + this.combineCheck + "    INSERT INTO " + this.tableName + "(" + String.join((CharSequence)", ", this.columns) + ")\n      VALUES(" + String.join((CharSequence)", ", this.values) + ")\n      RETURNING " + keyCols + " INTO " + String.join((CharSequence)", ", keyVars) + ";\n    if " + nullCheck + " then\n      raise_application_error(-20000, " + DbmsUtils.escapeAndEnquoteLiteral("Cannot insert element " + this.variableName + ". Please, provide non-null key values.", false) + ");\n    end if;\n    cnt := cnt + 1;\n";
    }
}

