/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation.expression;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.pgview.translation.GraphPatternTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableExpression;

public class XmlTable
extends TableExpression {
    public static final String ROWNUM_COL = "\"ROWN_$\"";
    public static final String ALIAS_SUFFIX = "_xmltab";
    public static final String DUMMY_COL = "\"DUMMY_$\"";
    public static final String DATE_FORMAT = "YYYY-MM-DD HH24:MI:SS";
    public static final String NLS_NUMERIC_CHARACTERS = "NLS_NUMERIC_CHARACTERS='.,'";
    public static final String TO_CHAR_NUM_FORMAT = "TM9";
    public static final String TO_NUMBER_NUM_FORMAT = XmlTable.getToNumberFormat();
    public static final int MAX_NUMBER_DIGITS = 20;
    public static final String TIMESTAMP_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF";
    public static final String TIMESTAMP_TZ_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF TZH:TZM";
    private final String baseAlias;
    private final String alias;
    private final List<Column> columns;
    private final boolean addRownum;
    private final boolean isReversed;

    public XmlTable(String baseAlias, List<Column> columns, boolean addRownum, boolean isReversed) {
        this.baseAlias = oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)baseAlias);
        this.alias = XmlTable.getTableAlias(baseAlias);
        this.columns = this.removeDuplicateColumns(columns);
        this.addRownum = addRownum;
        this.isReversed = isReversed;
    }

    private static String getToNumberFormat() {
        int i;
        StringBuilder format = new StringBuilder();
        for (i = 1; i <= 20; ++i) {
            format.append("9");
        }
        format.append("D");
        for (i = 1; i <= 20; ++i) {
            format.append("9");
        }
        return format.toString();
    }

    @Override
    public String prettyPrint() {
        String columnsClause = this.getColumnsClause();
        String xmlTable = "xmltable('/EXP_PATH/EXPRESSIONS' passing xmltype(nvl(" + this.baseAlias + ".\"EXP_PATH\", '')) " + columnsClause + ")";
        if (this.addRownum || this.addCast()) {
            boolean hasColumns;
            String selectColumns = this.columns.stream().map(Column::getExprForSelect).collect(Collectors.joining(", "));
            boolean bl = hasColumns = this.columns.size() > 0;
            if (this.isReversed) {
                xmlTable = "(SELECT " + (hasColumns ? selectColumns : "1") + " FROM " + xmlTable + " ORDER BY ROWNUM desc)";
            }
            xmlTable = "lateral ( SELECT " + selectColumns + (hasColumns ? ", " : "") + "ROWNUM AS " + ROWNUM_COL + " FROM " + xmlTable + ")";
        }
        return xmlTable + " " + this.alias;
    }

    private boolean addCast() {
        return this.columns.stream().anyMatch(column -> column.cast != null);
    }

    private List<Column> removeDuplicateColumns(List<Column> columns) {
        HashSet<String> columnNames = new HashSet<String>();
        ArrayList<Column> newColumns = new ArrayList<Column>();
        for (Column column : columns) {
            if (columnNames.contains(column.columnName)) continue;
            newColumns.add(column);
            columnNames.add(column.columnName);
        }
        return newColumns;
    }

    private String getColumnsClause() {
        return "columns " + (this.columns.size() > 0 ? this.columns.stream().map(Column::prettyPrint).collect(Collectors.joining(", ")) : "\"DUMMY_$\" VARCHAR2(1) path '/EXPRESSIONS'");
    }

    public static String getTableAlias(String baseAlias) {
        return oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)(baseAlias + ALIAS_SUFFIX));
    }

    public static class Column {
        final String columnName;
        final String type;
        final String path;
        final String cast;

        public Column(String columnName, String type, String path) {
            this.columnName = PgqlUtils.escapeAndEnquoteIdentifier(columnName);
            this.path = path;
            if (GraphPatternTranslator.isTimestamp(type)) {
                String castFunction = "to_timestamp";
                String format = XmlTable.TIMESTAMP_FORMAT;
                if (GraphPatternTranslator.hasTimeZone(type)) {
                    castFunction = castFunction + "_tz";
                    format = XmlTable.TIMESTAMP_TZ_FORMAT;
                }
                this.cast = castFunction + "(" + this.columnName + ", '" + format + "') AS " + this.columnName;
                this.type = "varchar2(4000)";
            } else if (GraphPatternTranslator.isDate(type)) {
                String castFunction = "to_date";
                this.cast = castFunction + "(" + this.columnName + ", '" + XmlTable.DATE_FORMAT + "') AS " + this.columnName;
                this.type = "varchar2(4000)";
            } else if (GraphPatternTranslator.isNumber(type)) {
                String castFunction = "to_number";
                this.cast = castFunction + "(" + this.columnName + ", '" + TO_NUMBER_NUM_FORMAT + "', " + DbmsUtils.escapeAndEnquoteLiteral(XmlTable.NLS_NUMERIC_CHARACTERS) + ") AS " + this.columnName;
                this.type = "varchar2(4000)";
            } else {
                this.cast = null;
                this.type = type;
            }
        }

        public String prettyPrint() {
            return this.columnName + " " + this.type + " path '" + this.path + "'";
        }

        public String getExprForSelect() {
            return this.cast == null ? this.columnName : this.cast;
        }
    }
}

