/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ddl.propertygraph;

import java.util.List;
import java.util.stream.Collectors;
import oracle.pgql.lang.ddl.propertygraph.Property;
import oracle.pgql.lang.ir.PgqlUtils;

public class Label {
    private String name;
    private List<Property> properties;
    private List<String> propertiesAreAllColumnsExcept;
    private boolean propertiesAreAllColumns;

    public Label(String name, List<Property> properties) {
        this.name = name;
        this.properties = properties;
    }

    public Label(String name, boolean propertiesAreAllColumns, List<String> except) {
        this(name, propertiesAreAllColumns);
        this.propertiesAreAllColumnsExcept = except;
    }

    public Label(String name, boolean propertiesAreAllColumns) {
        this.name = name;
        this.propertiesAreAllColumns = propertiesAreAllColumns;
        assert (propertiesAreAllColumns);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public List<String> getPropertiesAreAllColumnsExcept() {
        return this.propertiesAreAllColumnsExcept;
    }

    public void setPropertiesAreAllColumnsExcept(List<String> propertiesAreAllColumnsExcept) {
        this.propertiesAreAllColumnsExcept = propertiesAreAllColumnsExcept;
    }

    public boolean isPropertiesAreAllColumns() {
        return this.propertiesAreAllColumns;
    }

    public void setPropertiesAreAllColumns(boolean propertiesAreAllColumns) {
        this.propertiesAreAllColumns = propertiesAreAllColumns;
    }

    public String toString() {
        return "LABEL " + PgqlUtils.printIdentifier(this.name) + " " + this.printProperties();
    }

    String printProperties() {
        if (this.propertiesAreAllColumns) {
            assert (this.properties == null);
            if (this.propertiesAreAllColumnsExcept == null) {
                return "PROPERTIES ARE ALL COLUMNS";
            }
            return "PROPERTIES ARE ALL COLUMNS EXCEPT ( " + this.propertiesAreAllColumnsExcept.stream().map(x -> PgqlUtils.printIdentifier(x)).collect(Collectors.joining(", ")) + " )";
        }
        assert (this.properties != null);
        if (this.properties.isEmpty()) {
            return "NO PROPERTIES";
        }
        return "PROPERTIES ( " + this.properties.stream().map(x -> x.toString()).collect(Collectors.joining(", ")) + " )";
    }

    public int hashCode() {
        return 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Label other = (Label)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.propertiesAreAllColumns != other.propertiesAreAllColumns) {
            return false;
        }
        return !(this.propertiesAreAllColumnsExcept == null ? other.propertiesAreAllColumnsExcept != null : !this.propertiesAreAllColumnsExcept.equals(other.propertiesAreAllColumnsExcept));
    }
}

